/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.resources;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.internal.OtelEncodingUtils;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

public final class ContainerResource {
    private static final Logger logger = Logger.getLogger(ContainerResource.class.getName());
    private static final String UNIQUE_HOST_NAME_FILE_NAME = "/proc/self/cgroup";
    private static final Resource INSTANCE = ContainerResource.buildSingleton("/proc/self/cgroup");

    @IgnoreJRERequirement
    private static Resource buildSingleton(String uniqueHostNameFileName) {
        return ContainerResource.buildResource(Paths.get(uniqueHostNameFileName, new String[0]));
    }

    static Resource buildResource(Path path) {
        String containerId = ContainerResource.extractContainerId(path);
        if (containerId == null || containerId.isEmpty()) {
            return Resource.empty();
        }
        return Resource.create((Attributes)Attributes.of((AttributeKey)ResourceAttributes.CONTAINER_ID, (Object)containerId));
    }

    public static Resource get() {
        return INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @IgnoreJRERequirement
    private static String extractContainerId(Path cgroupFilePath) {
        if (!Files.exists(cgroupFilePath, new LinkOption[0])) return null;
        if (!Files.isReadable(cgroupFilePath)) {
            return null;
        }
        try (Stream<String> lines = Files.lines(cgroupFilePath);){
            Optional<String> value = lines.filter(line -> !line.isEmpty()).map(ContainerResource::getIdFromLine).filter(Objects::nonNull).findFirst();
            if (!value.isPresent()) return null;
            String string = value.get();
            return string;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unable to read file", e);
        }
        return null;
    }

    @Nullable
    private static String getIdFromLine(String line) {
        String containerId;
        int lastSlashIdx = line.lastIndexOf(47);
        if (lastSlashIdx < 0) {
            return null;
        }
        String lastSection = line.substring(lastSlashIdx + 1);
        int colonIdx = lastSection.lastIndexOf(58);
        if (colonIdx != -1) {
            containerId = lastSection.substring(colonIdx + 1);
        } else {
            int startIdx = lastSection.lastIndexOf(45);
            int endIdx = lastSection.lastIndexOf(46);
            int n = startIdx = startIdx == -1 ? 0 : startIdx + 1;
            if (endIdx == -1) {
                endIdx = lastSection.length();
            }
            if (startIdx > endIdx) {
                return null;
            }
            containerId = lastSection.substring(startIdx, endIdx);
        }
        if (OtelEncodingUtils.isValidBase16String((CharSequence)containerId) && !containerId.isEmpty()) {
            return containerId;
        }
        return null;
    }

    private ContainerResource() {
    }
}

