/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.logs.data.LogData;
import io.opentelemetry.sdk.logs.data.Severity;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.testing.assertj.AttributesAssert;
import io.opentelemetry.sdk.testing.assertj.OpenTelemetryAssertions;
import java.util.Map;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractAssert;

public class LogDataAssert
extends AbstractAssert<LogDataAssert, LogData> {
    protected LogDataAssert(LogData actual) {
        super((Object)actual, LogDataAssert.class);
    }

    public LogDataAssert hasResource(Resource resource) {
        this.isNotNull();
        if (!((LogData)this.actual).getResource().equals(resource)) {
            this.failWithActualExpectedAndMessage(this.actual, "resource: " + resource, "Expected log to have resource <%s> but found <%s>", new Object[]{resource, ((LogData)this.actual).getResource()});
        }
        return this;
    }

    public LogDataAssert hasInstrumentationScope(InstrumentationScopeInfo instrumentationScopeInfo) {
        this.isNotNull();
        if (!((LogData)this.actual).getInstrumentationScopeInfo().equals(instrumentationScopeInfo)) {
            this.failWithActualExpectedAndMessage(this.actual, "instrumentation scope: " + instrumentationScopeInfo, "Expected log to have scope <%s> but found <%s>", new Object[]{instrumentationScopeInfo, ((LogData)this.actual).getInstrumentationScopeInfo()});
        }
        return this;
    }

    public LogDataAssert hasEpochNanos(long epochNanos) {
        this.isNotNull();
        if (((LogData)this.actual).getEpochNanos() != epochNanos) {
            this.failWithActualExpectedAndMessage(((LogData)this.actual).getEpochNanos(), epochNanos, "Expected log to have epoch <%s> nanos but was <%s>", new Object[]{epochNanos, ((LogData)this.actual).getEpochNanos()});
        }
        return this;
    }

    public LogDataAssert hasSpanContext(SpanContext spanContext) {
        this.isNotNull();
        if (!((LogData)this.actual).getSpanContext().equals(spanContext)) {
            this.failWithActualExpectedAndMessage(((LogData)this.actual).getSpanContext(), spanContext, "Expected log to have span context <%s> nanos but was <%s>", new Object[]{spanContext, ((LogData)this.actual).getSpanContext()});
        }
        return this;
    }

    public LogDataAssert hasSeverity(Severity severity) {
        this.isNotNull();
        if (((LogData)this.actual).getSeverity() != severity) {
            this.failWithActualExpectedAndMessage(((LogData)this.actual).getSeverity(), severity, "Expected log to have severity <%s> but was <%s>", new Object[]{severity, ((LogData)this.actual).getSeverity()});
        }
        return this;
    }

    public LogDataAssert hasSeverityText(String severityText) {
        this.isNotNull();
        if (!severityText.equals(((LogData)this.actual).getSeverityText())) {
            this.failWithActualExpectedAndMessage(((LogData)this.actual).getSeverityText(), severityText, "Expected log to have severity text <%s> but was <%s>", new Object[]{severityText, ((LogData)this.actual).getSeverityText()});
        }
        return this;
    }

    public LogDataAssert hasBody(String body) {
        this.isNotNull();
        if (!((LogData)this.actual).getBody().asString().equals(body)) {
            this.failWithActualExpectedAndMessage(((LogData)this.actual).getBody(), body, "Expected log to have body <%s> but was <%s>", new Object[]{body, ((LogData)this.actual).getBody().asString()});
        }
        return this;
    }

    public LogDataAssert hasAttributes(Attributes attributes) {
        this.isNotNull();
        if (!this.attributesAreEqual(attributes)) {
            this.failWithActualExpectedAndMessage(((LogData)this.actual).getAttributes(), attributes, "Expected log to have attributes <%s> but was <%s>", new Object[]{attributes, ((LogData)this.actual).getAttributes()});
        }
        return this;
    }

    @SafeVarargs
    public final LogDataAssert hasAttributes(Map.Entry<? extends AttributeKey<?>, ?> ... entries) {
        AttributesBuilder attributesBuilder = Attributes.builder();
        for (Map.Entry<AttributeKey<?>, ?> entry : entries) {
            attributesBuilder.put(entry.getKey(), entry.getValue());
        }
        Attributes attributes = attributesBuilder.build();
        return this.hasAttributes(attributes);
    }

    public LogDataAssert hasAttributesSatisfying(Consumer<Attributes> attributes) {
        this.isNotNull();
        ((AttributesAssert)OpenTelemetryAssertions.assertThat((Attributes)((LogData)this.actual).getAttributes()).as("attributes", new Object[0])).satisfies(new Consumer[]{attributes});
        return this;
    }

    private boolean attributesAreEqual(Attributes attributes) {
        return ((LogData)this.actual).getAttributes().asMap().equals(attributes.asMap());
    }
}

