/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs.export;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.data.LogData;
import io.opentelemetry.sdk.logs.export.MultiLogExporter;
import io.opentelemetry.sdk.logs.export.NoopLogExporter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public interface LogExporter {
    public static LogExporter composite(LogExporter ... exporters) {
        return LogExporter.composite(Arrays.asList(exporters));
    }

    public static LogExporter composite(Iterable<LogExporter> exporters) {
        ArrayList<LogExporter> exportersList = new ArrayList<LogExporter>();
        for (LogExporter exporter : exporters) {
            exportersList.add(exporter);
        }
        if (exportersList.isEmpty()) {
            return NoopLogExporter.getInstance();
        }
        if (exportersList.size() == 1) {
            return (LogExporter)exportersList.get(0);
        }
        return MultiLogExporter.create(exportersList);
    }

    public CompletableResultCode export(Collection<LogData> var1);

    public CompletableResultCode flush();

    public CompletableResultCode shutdown();
}

