/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs.export;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class InMemoryLogRecordExporter
implements LogRecordExporter {
    private final Queue<LogRecordData> finishedLogItems = new ConcurrentLinkedQueue<LogRecordData>();
    private boolean isStopped = false;

    private InMemoryLogRecordExporter() {
    }

    public static InMemoryLogRecordExporter create() {
        return new InMemoryLogRecordExporter();
    }

    public List<LogRecordData> getFinishedLogItems() {
        return Collections.unmodifiableList(new ArrayList<LogRecordData>(this.finishedLogItems));
    }

    public void reset() {
        this.finishedLogItems.clear();
    }

    @Override
    public CompletableResultCode export(Collection<LogRecordData> logs) {
        if (this.isStopped) {
            return CompletableResultCode.ofFailure();
        }
        this.finishedLogItems.addAll(logs);
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        this.isStopped = true;
        this.finishedLogItems.clear();
        return CompletableResultCode.ofSuccess();
    }
}

