/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.SumData;
import org.assertj.core.api.AbstractAssert;

public class AbstractSumDataAssert<SumAssertT extends AbstractSumDataAssert<SumAssertT, SumT>, SumT extends SumData<?>>
extends AbstractAssert<SumAssertT, SumT> {
    protected AbstractSumDataAssert(SumT actual, Class<SumAssertT> assertClass) {
        super(actual, assertClass);
    }

    public SumAssertT isMonotonic() {
        this.isNotNull();
        if (!((SumData)this.actual).isMonotonic()) {
            this.failWithActualExpectedAndMessage(this.actual, "monotonic: true", "Expected Sum to be monotonic", new Object[]{true, ((SumData)this.actual).isMonotonic()});
        }
        return (SumAssertT)((Object)((AbstractSumDataAssert)this.myself));
    }

    public SumAssertT isNotMonotonic() {
        this.isNotNull();
        if (((SumData)this.actual).isMonotonic()) {
            this.failWithActualExpectedAndMessage(this.actual, "monotonic: fail", "Expected Sum to be non-monotonic, found: %s", new Object[]{((SumData)this.actual).isMonotonic()});
        }
        return (SumAssertT)((Object)((AbstractSumDataAssert)this.myself));
    }

    public SumAssertT isCumulative() {
        this.isNotNull();
        if (((SumData)this.actual).getAggregationTemporality() != AggregationTemporality.CUMULATIVE) {
            this.failWithActualExpectedAndMessage(this.actual, "aggregationTemporality: CUMULATIVE", "Expected Sum to have cumulative aggregation but found <%s>", new Object[]{((SumData)this.actual).getAggregationTemporality()});
        }
        return (SumAssertT)((Object)((AbstractSumDataAssert)this.myself));
    }

    public SumAssertT isDelta() {
        this.isNotNull();
        if (((SumData)this.actual).getAggregationTemporality() != AggregationTemporality.DELTA) {
            this.failWithActualExpectedAndMessage(this.actual, "aggregationTemporality: DELTA", "Expected Sum to have delta aggregation but found <%s>", new Object[]{((SumData)this.actual).getAggregationTemporality()});
        }
        return (SumAssertT)((Object)((AbstractSumDataAssert)this.myself));
    }
}

