/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.sdk.metrics.data.DoubleHistogramPointData;
import io.opentelemetry.sdk.testing.assertj.AbstractPointDataAssert;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;

public class DoubleHistogramPointDataAssert
extends AbstractPointDataAssert<DoubleHistogramPointDataAssert, DoubleHistogramPointData> {
    protected DoubleHistogramPointDataAssert(DoubleHistogramPointData actual) {
        super(actual, DoubleHistogramPointDataAssert.class);
    }

    public DoubleHistogramPointDataAssert hasSum(double expected) {
        this.isNotNull();
        ((AbstractDoubleAssert)Assertions.assertThat((double)((DoubleHistogramPointData)this.actual).getSum()).as("sum", new Object[0])).isEqualTo(expected);
        return this;
    }

    public DoubleHistogramPointDataAssert hasSumGreaterThan(double boundary) {
        this.isNotNull();
        ((AbstractDoubleAssert)Assertions.assertThat((double)((DoubleHistogramPointData)this.actual).getSum()).as("sum", new Object[0])).isGreaterThan(boundary);
        return this;
    }

    public DoubleHistogramPointDataAssert hasCount(long expected) {
        this.isNotNull();
        ((AbstractLongAssert)Assertions.assertThat((long)((DoubleHistogramPointData)this.actual).getCount()).as("count", new Object[0])).isEqualTo(expected);
        return this;
    }

    public DoubleHistogramPointDataAssert hasBucketBoundaries(double ... boundaries) {
        this.isNotNull();
        Object[] bigBoundaries = (Double[])Arrays.stream(boundaries).boxed().toArray(Double[]::new);
        ((ListAssert)Assertions.assertThat((List)((DoubleHistogramPointData)this.actual).getBoundaries()).as("boundaries", new Object[0])).containsExactly(bigBoundaries);
        return this;
    }

    public DoubleHistogramPointDataAssert hasBucketCounts(long ... counts) {
        this.isNotNull();
        Object[] bigCounts = (Long[])Arrays.stream(counts).boxed().toArray(Long[]::new);
        ((ListAssert)Assertions.assertThat((List)((DoubleHistogramPointData)this.actual).getCounts()).as("bucketCounts", new Object[0])).containsExactly(bigCounts);
        return this;
    }
}

