/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.DoubleHistogramData;
import io.opentelemetry.sdk.metrics.data.DoubleHistogramPointData;
import java.util.Collection;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIterableAssert;
import org.assertj.core.api.Assertions;

public class DoubleHistogramAssert
extends AbstractAssert<DoubleHistogramAssert, DoubleHistogramData> {
    protected DoubleHistogramAssert(DoubleHistogramData actual) {
        super((Object)actual, DoubleHistogramAssert.class);
    }

    public DoubleHistogramAssert isCumulative() {
        this.isNotNull();
        if (((DoubleHistogramData)this.actual).getAggregationTemporality() != AggregationTemporality.CUMULATIVE) {
            this.failWithActualExpectedAndMessage(this.actual, "aggregationTemporality: CUMULATIVE", "Expected Histogram to have cumulative aggregation but found <%s>", new Object[]{AggregationTemporality.CUMULATIVE, ((DoubleHistogramData)this.actual).getAggregationTemporality()});
        }
        return this;
    }

    public DoubleHistogramAssert isDelta() {
        this.isNotNull();
        if (((DoubleHistogramData)this.actual).getAggregationTemporality() != AggregationTemporality.DELTA) {
            this.failWithActualExpectedAndMessage(this.actual, "aggregationTemporality: DELTA", "Expected Histgram to have cumulative aggregation but found <%s>", new Object[]{AggregationTemporality.DELTA, ((DoubleHistogramData)this.actual).getAggregationTemporality()});
        }
        return this;
    }

    public AbstractIterableAssert<?, ? extends Iterable<? extends DoubleHistogramPointData>, DoubleHistogramPointData, ?> points() {
        this.isNotNull();
        return Assertions.assertThat((Collection)((DoubleHistogramData)this.actual).getPoints());
    }
}

