/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.HistogramData;
import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import java.util.Collection;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIterableAssert;
import org.assertj.core.api.Assertions;

public class HistogramAssert
extends AbstractAssert<HistogramAssert, HistogramData> {
    protected HistogramAssert(HistogramData actual) {
        super((Object)actual, HistogramAssert.class);
    }

    public HistogramAssert isCumulative() {
        this.isNotNull();
        if (((HistogramData)this.actual).getAggregationTemporality() != AggregationTemporality.CUMULATIVE) {
            this.failWithActualExpectedAndMessage(this.actual, "aggregationTemporality: CUMULATIVE", "Expected Histogram to have cumulative aggregation but found <%s>", new Object[]{AggregationTemporality.CUMULATIVE, ((HistogramData)this.actual).getAggregationTemporality()});
        }
        return this;
    }

    public HistogramAssert isDelta() {
        this.isNotNull();
        if (((HistogramData)this.actual).getAggregationTemporality() != AggregationTemporality.DELTA) {
            this.failWithActualExpectedAndMessage(this.actual, "aggregationTemporality: DELTA", "Expected Histgram to have cumulative aggregation but found <%s>", new Object[]{AggregationTemporality.DELTA, ((HistogramData)this.actual).getAggregationTemporality()});
        }
        return this;
    }

    public AbstractIterableAssert<?, ? extends Iterable<? extends HistogramPointData>, HistogramPointData, ?> points() {
        this.isNotNull();
        return Assertions.assertThat((Collection)((HistogramData)this.actual).getPoints());
    }
}

