/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.exporter;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.CollectionRegistration;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.internal.export.MetricProducer;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;

public class InMemoryMetricReader
implements MetricReader {
    private final AggregationTemporality aggregationTemporality;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    private volatile MetricProducer metricProducer = MetricProducer.noop();

    public static InMemoryMetricReader create() {
        return new InMemoryMetricReader(AggregationTemporality.CUMULATIVE);
    }

    public static InMemoryMetricReader createDelta() {
        return new InMemoryMetricReader(AggregationTemporality.DELTA);
    }

    private InMemoryMetricReader(AggregationTemporality aggregationTemporality) {
        this.aggregationTemporality = aggregationTemporality;
    }

    public Collection<MetricData> collectAllMetrics() {
        if (this.isShutdown.get()) {
            return Collections.emptyList();
        }
        return this.metricProducer.collectAllMetrics();
    }

    public void register(CollectionRegistration registration) {
        this.metricProducer = MetricProducer.asMetricProducer((CollectionRegistration)registration);
    }

    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return this.aggregationTemporality;
    }

    public CompletableResultCode flush() {
        this.collectAllMetrics();
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        this.isShutdown.set(true);
        return CompletableResultCode.ofSuccess();
    }
}

