/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.Labels;
import io.opentelemetry.api.metrics.AsynchronousInstrument;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.ActiveBatcher;
import io.opentelemetry.sdk.metrics.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSdk;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;

abstract class AbstractAsynchronousInstrument<T extends AsynchronousInstrument.Result>
extends AbstractInstrument
implements AsynchronousInstrument<T> {
    @Nullable
    private volatile AsynchronousInstrument.Callback<T> metricUpdater = null;
    private final ReentrantLock collectLock = new ReentrantLock();

    AbstractAsynchronousInstrument(InstrumentDescriptor descriptor, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, ActiveBatcher activeBatcher) {
        super(descriptor, meterProviderSharedState, meterSharedState, activeBatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<MetricData> collectAll() {
        AsynchronousInstrument.Callback<T> currentMetricUpdater = this.metricUpdater;
        if (currentMetricUpdater == null) {
            return Collections.emptyList();
        }
        this.collectLock.lock();
        try {
            ActiveBatcher activeBatcher = this.getActiveBatcher();
            currentMetricUpdater.update(this.newResult(activeBatcher));
            List<MetricData> list = activeBatcher.completeCollectionCycle();
            return list;
        }
        finally {
            this.collectLock.unlock();
        }
    }

    @Deprecated
    public void setCallback(AsynchronousInstrument.Callback<T> callback) {
        this.metricUpdater = Objects.requireNonNull(callback, "callback");
    }

    abstract T newResult(ActiveBatcher var1);

    static class AbstractDoubleAsynchronousInstrument
    extends AbstractAsynchronousInstrument<AsynchronousInstrument.DoubleResult> {
        AbstractDoubleAsynchronousInstrument(InstrumentDescriptor descriptor, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, ActiveBatcher activeBatcher) {
            super(descriptor, meterProviderSharedState, meterSharedState, activeBatcher);
        }

        @Override
        DoubleResultSdk newResult(ActiveBatcher activeBatcher) {
            return new DoubleResultSdk(activeBatcher);
        }

        private static final class DoubleResultSdk
        implements AsynchronousInstrument.DoubleResult {
            private final ActiveBatcher activeBatcher;

            private DoubleResultSdk(ActiveBatcher activeBatcher) {
                this.activeBatcher = activeBatcher;
            }

            public void observe(double sum, Labels labels) {
                Aggregator aggregator = this.activeBatcher.getAggregator();
                aggregator.recordDouble(sum);
                this.activeBatcher.batch(labels, aggregator, false);
            }
        }
    }

    static class AbstractLongAsynchronousInstrument
    extends AbstractAsynchronousInstrument<AsynchronousInstrument.LongResult> {
        AbstractLongAsynchronousInstrument(InstrumentDescriptor descriptor, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, ActiveBatcher activeBatcher) {
            super(descriptor, meterProviderSharedState, meterSharedState, activeBatcher);
        }

        @Override
        LongResultSdk newResult(ActiveBatcher activeBatcher) {
            return new LongResultSdk(activeBatcher);
        }

        private static final class LongResultSdk
        implements AsynchronousInstrument.LongResult {
            private final ActiveBatcher activeBatcher;

            private LongResultSdk(ActiveBatcher activeBatcher) {
                this.activeBatcher = activeBatcher;
            }

            public void observe(long sum, Labels labels) {
                Aggregator aggregator = this.activeBatcher.getAggregator();
                aggregator.recordLong(sum);
                this.activeBatcher.batch(labels, aggregator, false);
            }
        }
    }

    static abstract class Builder<B extends AbstractInstrument.Builder<?>>
    extends AbstractInstrument.Builder<B> {
        Builder(String name, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, MeterSdk meterSdk) {
            super(name, meterProviderSharedState, meterSharedState, meterSdk);
        }
    }
}

