/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.Labels;
import io.opentelemetry.api.metrics.AsynchronousInstrument;
import io.opentelemetry.sdk.metrics.InstrumentProcessor;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import javax.annotation.Nullable;

final class AsynchronousInstrumentAccumulator {
    private final ReentrantLock collectLock = new ReentrantLock();
    private final InstrumentProcessor instrumentProcessor;
    private final Consumer<InstrumentProcessor> metricUpdater;

    private AsynchronousInstrumentAccumulator(InstrumentProcessor instrumentProcessor, Consumer<InstrumentProcessor> metricUpdater) {
        this.metricUpdater = metricUpdater;
        this.instrumentProcessor = instrumentProcessor;
    }

    public List<MetricData> collectAll() {
        this.collectLock.lock();
        try {
            this.metricUpdater.accept(this.instrumentProcessor);
            List<MetricData> list = this.instrumentProcessor.completeCollectionCycle();
            return list;
        }
        finally {
            this.collectLock.unlock();
        }
    }

    static AsynchronousInstrumentAccumulator doubleAsynchronousAccumulator(InstrumentProcessor instrumentProcessor, @Nullable Consumer<AsynchronousInstrument.DoubleResult> metricUpdater) {
        if (metricUpdater == null) {
            return new AsynchronousInstrumentAccumulator(instrumentProcessor, instrumentProcessor1 -> {});
        }
        DoubleResultSdk result = new DoubleResultSdk(instrumentProcessor);
        return new AsynchronousInstrumentAccumulator(instrumentProcessor, instrumentProcessor1 -> metricUpdater.accept(result));
    }

    static AsynchronousInstrumentAccumulator longAsynchronousAccumulator(InstrumentProcessor instrumentProcessor, @Nullable Consumer<AsynchronousInstrument.LongResult> metricUpdater) {
        if (metricUpdater == null) {
            return new AsynchronousInstrumentAccumulator(instrumentProcessor, instrumentProcessor1 -> {});
        }
        LongResultSdk result = new LongResultSdk(instrumentProcessor);
        return new AsynchronousInstrumentAccumulator(instrumentProcessor, instrumentProcessor1 -> metricUpdater.accept(result));
    }

    private static final class LongResultSdk
    implements AsynchronousInstrument.LongResult {
        private final InstrumentProcessor instrumentProcessor;

        private LongResultSdk(InstrumentProcessor instrumentProcessor) {
            this.instrumentProcessor = instrumentProcessor;
        }

        public void observe(long sum, Labels labels) {
            Aggregator aggregator = this.instrumentProcessor.getAggregator();
            aggregator.recordLong(sum);
            this.instrumentProcessor.batch(labels, aggregator, false);
        }
    }

    private static final class DoubleResultSdk
    implements AsynchronousInstrument.DoubleResult {
        private final InstrumentProcessor instrumentProcessor;

        private DoubleResultSdk(InstrumentProcessor instrumentProcessor) {
            this.instrumentProcessor = instrumentProcessor;
        }

        public void observe(double sum, Labels labels) {
            Aggregator aggregator = this.instrumentProcessor.getAggregator();
            aggregator.recordDouble(sum);
            this.instrumentProcessor.batch(labels, aggregator, false);
        }
    }
}

