/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.Labels;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.sdk.metrics.AbstractBoundInstrument;
import io.opentelemetry.sdk.metrics.AbstractSynchronousInstrument;
import io.opentelemetry.sdk.metrics.AbstractSynchronousInstrumentBuilder;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.SynchronousInstrumentAccumulator;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;

final class LongCounterSdk
extends AbstractSynchronousInstrument<BoundInstrument>
implements LongCounter {
    private LongCounterSdk(InstrumentDescriptor descriptor, SynchronousInstrumentAccumulator<BoundInstrument> accumulator) {
        super(descriptor, accumulator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long increment, Labels labels) {
        BoundInstrument boundInstrument = (BoundInstrument)this.bind(labels);
        try {
            boundInstrument.add(increment);
        }
        finally {
            boundInstrument.unbind();
        }
    }

    public void add(long increment) {
        this.add(increment, Labels.empty());
    }

    static final class Builder
    extends AbstractSynchronousInstrumentBuilder<Builder>
    implements LongCounter.Builder {
        Builder(String name, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
            super(name, InstrumentType.COUNTER, InstrumentValueType.LONG, meterProviderSharedState, meterSharedState);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public LongCounterSdk build() {
            return this.buildInstrument(BoundInstrument::new, (x$0, x$1) -> new LongCounterSdk((InstrumentDescriptor)x$0, (SynchronousInstrumentAccumulator)x$1));
        }
    }

    static final class BoundInstrument
    extends AbstractBoundInstrument
    implements LongCounter.BoundLongCounter {
        BoundInstrument(Aggregator aggregator) {
            super(aggregator);
        }

        public void add(long increment) {
            if (increment < 0L) {
                throw new IllegalArgumentException("Counters can only increase");
            }
            this.recordLong(increment);
        }
    }
}

