/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.Labels;
import io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.sdk.metrics.AbstractBoundInstrument;
import io.opentelemetry.sdk.metrics.AbstractSynchronousInstrument;
import io.opentelemetry.sdk.metrics.AbstractSynchronousInstrumentBuilder;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.SynchronousInstrumentAccumulator;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;

final class LongUpDownCounterSdk
extends AbstractSynchronousInstrument<BoundInstrument>
implements LongUpDownCounter {
    private LongUpDownCounterSdk(InstrumentDescriptor descriptor, SynchronousInstrumentAccumulator<BoundInstrument> accumulator) {
        super(descriptor, accumulator);
    }

    public void add(long increment, Labels labels) {
        BoundInstrument boundInstrument = (BoundInstrument)this.bind(labels);
        boundInstrument.add(increment);
        boundInstrument.unbind();
    }

    public void add(long increment) {
        this.add(increment, Labels.empty());
    }

    static final class Builder
    extends AbstractSynchronousInstrumentBuilder<Builder>
    implements LongUpDownCounter.Builder {
        Builder(String name, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
            super(name, InstrumentType.UP_DOWN_COUNTER, InstrumentValueType.LONG, meterProviderSharedState, meterSharedState);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public LongUpDownCounterSdk build() {
            return this.buildInstrument(BoundInstrument::new, (x$0, x$1) -> new LongUpDownCounterSdk((InstrumentDescriptor)x$0, (SynchronousInstrumentAccumulator)x$1));
        }
    }

    static final class BoundInstrument
    extends AbstractBoundInstrument
    implements LongUpDownCounter.BoundLongUpDownCounter {
        BoundInstrument(Aggregator aggregator) {
            super(aggregator);
        }

        public void add(long increment) {
            this.recordLong(increment);
        }
    }
}

