/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.Labels;
import io.opentelemetry.sdk.metrics.AbstractBoundInstrument;
import io.opentelemetry.sdk.metrics.InstrumentProcessor;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;

final class SynchronousInstrumentAccumulator<B extends AbstractBoundInstrument> {
    private final ConcurrentHashMap<Labels, B> boundLabels;
    private final ReentrantLock collectLock;
    private final InstrumentProcessor instrumentProcessor;
    private final Function<Aggregator, B> boundFactory;

    SynchronousInstrumentAccumulator(InstrumentProcessor instrumentProcessor, Function<Aggregator, B> boundFactory) {
        this.boundFactory = boundFactory;
        this.boundLabels = new ConcurrentHashMap();
        this.collectLock = new ReentrantLock();
        this.instrumentProcessor = instrumentProcessor;
    }

    public B bind(Labels labels) {
        AbstractBoundInstrument oldBound;
        Objects.requireNonNull(labels, "labels");
        AbstractBoundInstrument binding = (AbstractBoundInstrument)this.boundLabels.get(labels);
        if (binding != null && binding.bind()) {
            return (B)binding;
        }
        binding = (AbstractBoundInstrument)this.boundFactory.apply(this.instrumentProcessor.getAggregator());
        while ((oldBound = this.boundLabels.putIfAbsent(labels, binding)) != null) {
            if (oldBound.bind()) {
                return (B)oldBound;
            }
            this.boundLabels.remove(labels, oldBound);
        }
        return (B)binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<MetricData> collectAll() {
        this.collectLock.lock();
        try {
            for (Map.Entry<Labels, B> entry : this.boundLabels.entrySet()) {
                boolean unmappedEntry = ((AbstractBoundInstrument)entry.getValue()).tryUnmap();
                if (unmappedEntry) {
                    this.boundLabels.remove(entry.getKey(), entry.getValue());
                }
                this.instrumentProcessor.batch(entry.getKey(), ((AbstractBoundInstrument)entry.getValue()).getAggregator(), !unmappedEntry);
            }
            List<MetricData> list = this.instrumentProcessor.completeCollectionCycle();
            return list;
        }
        finally {
            this.collectLock.unlock();
        }
    }
}

