/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.sdk.metrics.AggregationChooser;
import io.opentelemetry.sdk.metrics.InstrumentProcessor;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.view.Aggregation;
import io.opentelemetry.sdk.metrics.view.AggregationConfiguration;
import io.opentelemetry.sdk.metrics.view.InstrumentSelector;

class ViewRegistry {
    private final AggregationChooser aggregationChooser;

    ViewRegistry() {
        this(new AggregationChooser());
    }

    ViewRegistry(AggregationChooser aggregationChooser) {
        this.aggregationChooser = aggregationChooser;
    }

    void registerView(InstrumentSelector selector, AggregationConfiguration specification) {
        this.aggregationChooser.addView(selector, specification);
    }

    InstrumentProcessor createBatcher(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, InstrumentDescriptor descriptor) {
        AggregationConfiguration specification = this.aggregationChooser.chooseAggregation(descriptor);
        Aggregation aggregation = specification.aggregation();
        if (MetricData.AggregationTemporality.CUMULATIVE == specification.temporality()) {
            return InstrumentProcessor.getCumulativeAllLabels(descriptor, meterProviderSharedState, meterSharedState, aggregation);
        }
        if (MetricData.AggregationTemporality.DELTA == specification.temporality()) {
            return InstrumentProcessor.getDeltaAllLabels(descriptor, meterProviderSharedState, meterSharedState, aggregation);
        }
        throw new IllegalStateException("unsupported Temporality: " + (Object)((Object)specification.temporality()));
    }
}

