/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.aggregator;

import io.opentelemetry.api.common.Labels;
import io.opentelemetry.sdk.metrics.aggregator.AbstractAggregator;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.util.concurrent.atomic.DoubleAdder;

public final class DoubleSumAggregator
extends AbstractAggregator {
    private static final AggregatorFactory AGGREGATOR_FACTORY = DoubleSumAggregator::new;
    private final DoubleAdder current = new DoubleAdder();

    public static AggregatorFactory getFactory() {
        return AGGREGATOR_FACTORY;
    }

    @Override
    void doMergeAndReset(Aggregator aggregator) {
        DoubleSumAggregator other = (DoubleSumAggregator)aggregator;
        other.current.add(this.current.sumThenReset());
    }

    @Override
    public MetricData.Point toPoint(long startEpochNanos, long epochNanos, Labels labels) {
        return MetricData.DoublePoint.create(startEpochNanos, epochNanos, labels, this.current.sum());
    }

    @Override
    public void doRecordDouble(double value) {
        this.current.add(value);
    }
}

