/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.data;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.Labels;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.data.AutoValue_MetricData;
import io.opentelemetry.sdk.metrics.data.AutoValue_MetricData_DoubleGaugeData;
import io.opentelemetry.sdk.metrics.data.AutoValue_MetricData_DoublePoint;
import io.opentelemetry.sdk.metrics.data.AutoValue_MetricData_DoubleSumData;
import io.opentelemetry.sdk.metrics.data.AutoValue_MetricData_DoubleSummaryData;
import io.opentelemetry.sdk.metrics.data.AutoValue_MetricData_DoubleSummaryPoint;
import io.opentelemetry.sdk.metrics.data.AutoValue_MetricData_LongGaugeData;
import io.opentelemetry.sdk.metrics.data.AutoValue_MetricData_LongPoint;
import io.opentelemetry.sdk.metrics.data.AutoValue_MetricData_LongSumData;
import io.opentelemetry.sdk.metrics.data.AutoValue_MetricData_ValueAtPercentile;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class MetricData {
    private static final DoubleGaugeData DEFAULT_DOUBLE_GAUGE_DATA = DoubleGaugeData.create(Collections.emptyList());
    private static final LongGaugeData DEFAULT_LONG_GAUGE_DATA = LongGaugeData.create(Collections.emptyList());
    private static final DoubleSumData DEFAULT_DOUBLE_SUM_DATA = DoubleSumData.create(false, AggregationTemporality.CUMULATIVE, Collections.emptyList());
    private static final LongSumData DEFAULT_LONG_SUM_DATA = LongSumData.create(false, AggregationTemporality.CUMULATIVE, Collections.emptyList());
    private static final DoubleSummaryData DEFAULT_DOUBLE_SUMMARY_DATA = DoubleSummaryData.create(Collections.emptyList());

    public static MetricData createDoubleGauge(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, String name, String description, String unit, DoubleGaugeData data) {
        return new AutoValue_MetricData(resource, instrumentationLibraryInfo, name, description, unit, Type.DOUBLE_GAUGE, data);
    }

    public static MetricData createLongGauge(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, String name, String description, String unit, LongGaugeData data) {
        return new AutoValue_MetricData(resource, instrumentationLibraryInfo, name, description, unit, Type.LONG_GAUGE, data);
    }

    public static MetricData createDoubleSum(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, String name, String description, String unit, DoubleSumData data) {
        return new AutoValue_MetricData(resource, instrumentationLibraryInfo, name, description, unit, Type.DOUBLE_SUM, data);
    }

    public static MetricData createLongSum(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, String name, String description, String unit, LongSumData data) {
        return new AutoValue_MetricData(resource, instrumentationLibraryInfo, name, description, unit, Type.LONG_SUM, data);
    }

    public static MetricData createDoubleSummary(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, String name, String description, String unit, DoubleSummaryData data) {
        return new AutoValue_MetricData(resource, instrumentationLibraryInfo, name, description, unit, Type.SUMMARY, data);
    }

    MetricData() {
    }

    public abstract Resource getResource();

    public abstract InstrumentationLibraryInfo getInstrumentationLibraryInfo();

    public abstract String getName();

    public abstract String getDescription();

    public abstract String getUnit();

    public abstract Type getType();

    abstract Data getData();

    public boolean isEmpty() {
        return this.getData().getPoints().isEmpty();
    }

    public final DoubleGaugeData getDoubleGaugeData() {
        if (this.getType() == Type.DOUBLE_GAUGE) {
            return (DoubleGaugeData)this.getData();
        }
        return DEFAULT_DOUBLE_GAUGE_DATA;
    }

    public final LongGaugeData getLongGaugeData() {
        if (this.getType() == Type.LONG_GAUGE) {
            return (LongGaugeData)this.getData();
        }
        return DEFAULT_LONG_GAUGE_DATA;
    }

    public final DoubleSumData getDoubleSumData() {
        if (this.getType() == Type.DOUBLE_SUM) {
            return (DoubleSumData)this.getData();
        }
        return DEFAULT_DOUBLE_SUM_DATA;
    }

    public final LongSumData getLongSumData() {
        if (this.getType() == Type.LONG_SUM) {
            return (LongSumData)this.getData();
        }
        return DEFAULT_LONG_SUM_DATA;
    }

    public final DoubleSummaryData getDoubleSummaryData() {
        if (this.getType() == Type.SUMMARY) {
            return (DoubleSummaryData)this.getData();
        }
        return DEFAULT_DOUBLE_SUMMARY_DATA;
    }

    public Collection<Point> getPoints() {
        return this.getData().getPoints();
    }

    @Immutable
    @AutoValue
    public static abstract class ValueAtPercentile {
        ValueAtPercentile() {
        }

        public abstract double getPercentile();

        public abstract double getValue();

        public static ValueAtPercentile create(double percentile, double value) {
            return new AutoValue_MetricData_ValueAtPercentile(percentile, value);
        }
    }

    @Immutable
    @AutoValue
    public static abstract class DoubleSummaryPoint
    extends Point {
        DoubleSummaryPoint() {
        }

        public abstract long getCount();

        public abstract double getSum();

        public abstract List<ValueAtPercentile> getPercentileValues();

        public static DoubleSummaryPoint create(long startEpochNanos, long epochNanos, Labels labels, long count, double sum, List<ValueAtPercentile> percentileValues) {
            return new AutoValue_MetricData_DoubleSummaryPoint(startEpochNanos, epochNanos, labels, count, sum, percentileValues);
        }
    }

    @Immutable
    @AutoValue
    public static abstract class DoublePoint
    extends Point {
        DoublePoint() {
        }

        public abstract double getValue();

        public static DoublePoint create(long startEpochNanos, long epochNanos, Labels labels, double value) {
            return new AutoValue_MetricData_DoublePoint(startEpochNanos, epochNanos, labels, value);
        }
    }

    @Immutable
    @AutoValue
    public static abstract class LongPoint
    extends Point {
        LongPoint() {
        }

        public abstract long getValue();

        public static LongPoint create(long startEpochNanos, long epochNanos, Labels labels, long value) {
            return new AutoValue_MetricData_LongPoint(startEpochNanos, epochNanos, labels, value);
        }
    }

    @Immutable
    public static abstract class Point {
        Point() {
        }

        public abstract long getStartEpochNanos();

        public abstract long getEpochNanos();

        public abstract Labels getLabels();
    }

    @Immutable
    @AutoValue
    public static abstract class DoubleSummaryData
    extends Data {
        public static DoubleSummaryData create(Collection<Point> points) {
            return new AutoValue_MetricData_DoubleSummaryData(points);
        }

        @Override
        public abstract Collection<Point> getPoints();
    }

    @Immutable
    @AutoValue
    public static abstract class LongSumData
    extends SumData {
        public static LongSumData create(boolean isMonotonic, AggregationTemporality temporality, Collection<Point> points) {
            return new AutoValue_MetricData_LongSumData(isMonotonic, temporality, points);
        }

        @Override
        public abstract Collection<Point> getPoints();
    }

    @Immutable
    @AutoValue
    public static abstract class DoubleSumData
    extends SumData {
        public static DoubleSumData create(boolean isMonotonic, AggregationTemporality temporality, Collection<Point> points) {
            return new AutoValue_MetricData_DoubleSumData(isMonotonic, temporality, points);
        }

        @Override
        public abstract Collection<Point> getPoints();
    }

    @Immutable
    static abstract class SumData
    extends Data {
        SumData() {
        }

        public abstract boolean isMonotonic();

        public abstract AggregationTemporality getAggregationTemporality();
    }

    @Immutable
    @AutoValue
    public static abstract class LongGaugeData
    extends Data {
        public static LongGaugeData create(List<Point> points) {
            return new AutoValue_MetricData_LongGaugeData(points);
        }

        @Override
        public abstract Collection<Point> getPoints();
    }

    @Immutable
    @AutoValue
    public static abstract class DoubleGaugeData
    extends Data {
        public static DoubleGaugeData create(List<Point> points) {
            return new AutoValue_MetricData_DoubleGaugeData(points);
        }

        @Override
        public abstract Collection<Point> getPoints();
    }

    @Immutable
    static abstract class Data {
        Data() {
        }

        public abstract Collection<Point> getPoints();
    }

    public static enum AggregationTemporality {
        DELTA,
        CUMULATIVE;

    }

    public static enum Type {
        LONG_GAUGE,
        DOUBLE_GAUGE,
        LONG_SUM,
        DOUBLE_SUM,
        SUMMARY;

    }
}

