/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.aggregator;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.Labels;
import io.opentelemetry.sdk.metrics.aggregator.AutoValue_MinMaxSumCountAccumulation;
import io.opentelemetry.sdk.metrics.data.DoubleSummaryPoint;
import io.opentelemetry.sdk.metrics.data.ValueAtPercentile;
import java.util.Arrays;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
abstract class MinMaxSumCountAccumulation {
    static MinMaxSumCountAccumulation create(long count, double sum, double min, double max) {
        return new AutoValue_MinMaxSumCountAccumulation(count, sum, min, max);
    }

    MinMaxSumCountAccumulation() {
    }

    abstract long getCount();

    abstract double getSum();

    abstract double getMin();

    abstract double getMax();

    final DoubleSummaryPoint toPoint(long startEpochNanos, long epochNanos, Labels labels) {
        return DoubleSummaryPoint.create(startEpochNanos, epochNanos, labels, this.getCount(), this.getSum(), Arrays.asList(ValueAtPercentile.create(0.0, this.getMin()), ValueAtPercentile.create(100.0, this.getMax())));
    }
}

