/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.internal.StringUtils;
import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.api.metrics.Instrument;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.util.List;
import java.util.Objects;

abstract class AbstractInstrument
implements Instrument {
    private final InstrumentDescriptor descriptor;

    AbstractInstrument(InstrumentDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    final InstrumentDescriptor getDescriptor() {
        return this.descriptor;
    }

    abstract List<MetricData> collectAll(long var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractInstrument)) {
            return false;
        }
        AbstractInstrument that = (AbstractInstrument)o;
        return this.descriptor.equals(that.descriptor);
    }

    public int hashCode() {
        return this.descriptor.hashCode();
    }

    static abstract class Builder<B extends Builder<?>>
    implements Instrument.Builder {
        static final String ERROR_MESSAGE_INVALID_NAME = "Name should be a ASCII string with a length no greater than 255 characters.";
        private final String name;
        private final InstrumentType instrumentType;
        private final InstrumentValueType instrumentValueType;
        private String description = "";
        private String unit = "1";

        Builder(String name, InstrumentType instrumentType, InstrumentValueType instrumentValueType) {
            Objects.requireNonNull(name, "name");
            Utils.checkArgument((boolean)StringUtils.isValidMetricName((String)name), (String)ERROR_MESSAGE_INVALID_NAME);
            this.name = name;
            this.instrumentType = instrumentType;
            this.instrumentValueType = instrumentValueType;
        }

        public final B setDescription(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this.getThis();
        }

        public final B setUnit(String unit) {
            this.unit = Objects.requireNonNull(unit, "unit");
            return this.getThis();
        }

        abstract B getThis();

        final InstrumentDescriptor buildDescriptor() {
            return InstrumentDescriptor.create(this.name, this.description, this.unit, this.instrumentType, this.instrumentValueType);
        }
    }
}

