/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.sdk.metrics.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.view.AggregationConfiguration;
import io.opentelemetry.sdk.metrics.view.InstrumentSelector;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;

final class ViewRegistry {
    private static final LinkedHashMap<Pattern, AggregationConfiguration> EMPTY_CONFIG = new LinkedHashMap();
    private static final AggregationConfiguration CUMULATIVE_SUM = AggregationConfiguration.create(AggregatorFactory.sum(), AggregationTemporality.CUMULATIVE);
    private static final AggregationConfiguration DELTA_SUMMARY = AggregationConfiguration.create(AggregatorFactory.minMaxSumCount(), AggregationTemporality.DELTA);
    private static final AggregationConfiguration CUMULATIVE_LAST_VALUE = AggregationConfiguration.create(AggregatorFactory.lastValue(), AggregationTemporality.CUMULATIVE);
    private static final AggregationConfiguration DELTA_LAST_VALUE = AggregationConfiguration.create(AggregatorFactory.lastValue(), AggregationTemporality.DELTA);
    private final ReentrantLock lock = new ReentrantLock();
    private volatile EnumMap<InstrumentType, LinkedHashMap<Pattern, AggregationConfiguration>> configuration = new EnumMap(InstrumentType.class);

    ViewRegistry() {
        this.configuration.put(InstrumentType.COUNTER, EMPTY_CONFIG);
        this.configuration.put(InstrumentType.UP_DOWN_COUNTER, EMPTY_CONFIG);
        this.configuration.put(InstrumentType.VALUE_RECORDER, EMPTY_CONFIG);
        this.configuration.put(InstrumentType.SUM_OBSERVER, EMPTY_CONFIG);
        this.configuration.put(InstrumentType.UP_DOWN_SUM_OBSERVER, EMPTY_CONFIG);
        this.configuration.put(InstrumentType.VALUE_OBSERVER, EMPTY_CONFIG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerView(InstrumentSelector selector, AggregationConfiguration specification) {
        this.lock.lock();
        try {
            EnumMap<InstrumentType, LinkedHashMap<Pattern, AggregationConfiguration>> newConfiguration = new EnumMap<InstrumentType, LinkedHashMap<Pattern, AggregationConfiguration>>(this.configuration);
            newConfiguration.put(selector.getInstrumentType(), ViewRegistry.newLinkedHashMap(selector.getInstrumentNamePattern(), specification, newConfiguration.get((Object)selector.getInstrumentType())));
            this.configuration = newConfiguration;
        }
        finally {
            this.lock.unlock();
        }
    }

    AggregationConfiguration findView(InstrumentDescriptor descriptor) {
        LinkedHashMap<Pattern, AggregationConfiguration> configPerType = this.configuration.get((Object)descriptor.getType());
        for (Map.Entry<Pattern, AggregationConfiguration> entry : configPerType.entrySet()) {
            if (!entry.getKey().matcher(descriptor.getName()).matches()) continue;
            return entry.getValue();
        }
        return ViewRegistry.getDefaultSpecification(descriptor);
    }

    private static AggregationConfiguration getDefaultSpecification(InstrumentDescriptor descriptor) {
        switch (descriptor.getType()) {
            case COUNTER: 
            case UP_DOWN_COUNTER: {
                return CUMULATIVE_SUM;
            }
            case VALUE_RECORDER: {
                return DELTA_SUMMARY;
            }
            case VALUE_OBSERVER: {
                return DELTA_LAST_VALUE;
            }
            case SUM_OBSERVER: 
            case UP_DOWN_SUM_OBSERVER: {
                return CUMULATIVE_LAST_VALUE;
            }
        }
        throw new IllegalArgumentException("Unknown descriptor type: " + (Object)((Object)descriptor.getType()));
    }

    private static LinkedHashMap<Pattern, AggregationConfiguration> newLinkedHashMap(Pattern pattern, AggregationConfiguration aggregationConfiguration, LinkedHashMap<Pattern, AggregationConfiguration> parentConfiguration) {
        LinkedHashMap<Pattern, AggregationConfiguration> result = new LinkedHashMap<Pattern, AggregationConfiguration>();
        result.put(pattern, aggregationConfiguration);
        result.putAll(parentConfiguration);
        return result;
    }
}

