/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.export;

import com.google.auto.value.AutoValue;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.internal.DaemonThreadFactory;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.AutoValue_IntervalMetricReader_InternalState;
import io.opentelemetry.sdk.metrics.export.IntervalMetricReaderBuilder;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricProducer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;

public final class IntervalMetricReader {
    private static final Logger logger = Logger.getLogger(IntervalMetricReader.class.getName());
    private final Exporter exporter;
    private final ScheduledExecutorService scheduler;

    public void shutdown() {
        this.scheduler.shutdown();
        try {
            this.scheduler.awaitTermination(5L, TimeUnit.SECONDS);
            this.exporter.run();
        }
        catch (InterruptedException e) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
        finally {
            this.exporter.shutdown();
        }
    }

    public static IntervalMetricReaderBuilder builder() {
        return new IntervalMetricReaderBuilder(InternalState.builder());
    }

    public static IntervalMetricReaderBuilder builderFromDefaultSources() {
        return (IntervalMetricReaderBuilder)((Object)((IntervalMetricReaderBuilder)((Object)IntervalMetricReader.builder().readEnvironmentVariables())).readSystemProperties());
    }

    IntervalMetricReader(InternalState internalState) {
        this.exporter = new Exporter(internalState);
        this.scheduler = Executors.newScheduledThreadPool(1, (ThreadFactory)new DaemonThreadFactory("IntervalMetricReader"));
        this.scheduler.scheduleAtFixedRate(this.exporter, internalState.getExportIntervalMillis(), internalState.getExportIntervalMillis(), TimeUnit.MILLISECONDS);
    }

    @AutoValue
    @Immutable
    static abstract class InternalState {
        static final long DEFAULT_INTERVAL_MILLIS = 60000L;

        InternalState() {
        }

        abstract MetricExporter getMetricExporter();

        abstract long getExportIntervalMillis();

        abstract Collection<MetricProducer> getMetricProducers();

        static Builder builder() {
            return new AutoValue_IntervalMetricReader_InternalState.Builder().setExportIntervalMillis(60000L);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setExportIntervalMillis(long var1);

            abstract Builder setMetricExporter(MetricExporter var1);

            abstract Builder setMetricProducers(Collection<MetricProducer> var1);

            abstract InternalState build();
        }
    }

    private static final class Exporter
    implements Runnable {
        private final InternalState internalState;
        private final AtomicBoolean exportAvailable = new AtomicBoolean(true);

        private Exporter(InternalState internalState) {
            this.internalState = internalState;
        }

        @Override
        public void run() {
            if (this.exportAvailable.compareAndSet(true, false)) {
                try {
                    ArrayList<MetricData> metricsList = new ArrayList<MetricData>();
                    for (MetricProducer metricProducer : this.internalState.getMetricProducers()) {
                        metricsList.addAll(metricProducer.collectAllMetrics());
                    }
                    CompletableResultCode result = this.internalState.getMetricExporter().export(Collections.unmodifiableList(metricsList));
                    result.whenComplete(() -> {
                        if (!result.isSuccess()) {
                            logger.log(Level.FINE, "Exporter failed");
                        }
                        this.exportAvailable.set(true);
                    });
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Exporter threw an Exception", e);
                }
            } else {
                logger.log(Level.FINE, "Exporter busy. Dropping metrics.");
            }
        }

        void shutdown() {
            this.internalState.getMetricExporter().shutdown();
        }
    }
}

