/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.Labels;
import io.opentelemetry.api.metrics.BoundLongValueRecorder;
import io.opentelemetry.api.metrics.LongValueRecorder;
import io.opentelemetry.api.metrics.LongValueRecorderBuilder;
import io.opentelemetry.sdk.metrics.AbstractSynchronousInstrument;
import io.opentelemetry.sdk.metrics.AbstractSynchronousInstrumentBuilder;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.SynchronousInstrumentAccumulator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;

final class LongValueRecorderSdk
extends AbstractSynchronousInstrument
implements LongValueRecorder {
    private LongValueRecorderSdk(InstrumentDescriptor descriptor, SynchronousInstrumentAccumulator<?> accumulator) {
        super(descriptor, accumulator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(long value, Labels labels) {
        AggregatorHandle<?> aggregatorHandle = this.acquireHandle(labels);
        try {
            aggregatorHandle.recordLong(value);
        }
        finally {
            aggregatorHandle.release();
        }
    }

    public void record(long value) {
        this.record(value, Labels.empty());
    }

    public BoundLongValueRecorder bind(Labels labels) {
        return new BoundInstrument(this.acquireHandle(labels));
    }

    static final class Builder
    extends AbstractSynchronousInstrumentBuilder<Builder>
    implements LongValueRecorderBuilder {
        Builder(String name, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
            super(name, InstrumentType.VALUE_RECORDER, InstrumentValueType.LONG, meterProviderSharedState, meterSharedState);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public LongValueRecorderSdk build() {
            return this.buildInstrument((x$0, x$1) -> new LongValueRecorderSdk((InstrumentDescriptor)x$0, (SynchronousInstrumentAccumulator)x$1));
        }
    }

    static final class BoundInstrument
    implements BoundLongValueRecorder {
        private final AggregatorHandle<?> aggregatorHandle;

        BoundInstrument(AggregatorHandle<?> aggregatorHandle) {
            this.aggregatorHandle = aggregatorHandle;
        }

        public void record(long value) {
            this.aggregatorHandle.recordLong(value);
        }

        public void unbind() {
            this.aggregatorHandle.release();
        }
    }
}

