/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.sdk.metrics.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.view.InstrumentSelector;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;

final class ViewRegistry {
    private static final LinkedHashMap<Pattern, AggregatorFactory> EMPTY_CONFIG = new LinkedHashMap();
    static final AggregatorFactory CUMULATIVE_SUM = AggregatorFactory.sum(true);
    static final AggregatorFactory SUMMARY = AggregatorFactory.minMaxSumCount();
    static final AggregatorFactory LAST_VALUE = AggregatorFactory.lastValue();
    private final ReentrantLock lock = new ReentrantLock();
    private volatile EnumMap<InstrumentType, LinkedHashMap<Pattern, AggregatorFactory>> configuration = new EnumMap(InstrumentType.class);

    ViewRegistry() {
        this.configuration.put(InstrumentType.COUNTER, EMPTY_CONFIG);
        this.configuration.put(InstrumentType.UP_DOWN_COUNTER, EMPTY_CONFIG);
        this.configuration.put(InstrumentType.VALUE_RECORDER, EMPTY_CONFIG);
        this.configuration.put(InstrumentType.SUM_OBSERVER, EMPTY_CONFIG);
        this.configuration.put(InstrumentType.UP_DOWN_SUM_OBSERVER, EMPTY_CONFIG);
        this.configuration.put(InstrumentType.VALUE_OBSERVER, EMPTY_CONFIG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerView(InstrumentSelector selector, AggregatorFactory aggregatorFactory) {
        this.lock.lock();
        try {
            EnumMap<InstrumentType, LinkedHashMap<Pattern, AggregatorFactory>> newConfiguration = new EnumMap<InstrumentType, LinkedHashMap<Pattern, AggregatorFactory>>(this.configuration);
            newConfiguration.put(selector.getInstrumentType(), ViewRegistry.newLinkedHashMap(selector.getInstrumentNamePattern(), aggregatorFactory, newConfiguration.get((Object)selector.getInstrumentType())));
            this.configuration = newConfiguration;
        }
        finally {
            this.lock.unlock();
        }
    }

    AggregatorFactory findView(InstrumentDescriptor descriptor) {
        LinkedHashMap<Pattern, AggregatorFactory> configPerType = this.configuration.get((Object)descriptor.getType());
        for (Map.Entry<Pattern, AggregatorFactory> entry : configPerType.entrySet()) {
            if (!entry.getKey().matcher(descriptor.getName()).matches()) continue;
            return entry.getValue();
        }
        return ViewRegistry.getDefaultSpecification(descriptor);
    }

    private static AggregatorFactory getDefaultSpecification(InstrumentDescriptor descriptor) {
        switch (descriptor.getType()) {
            case COUNTER: 
            case UP_DOWN_COUNTER: 
            case SUM_OBSERVER: 
            case UP_DOWN_SUM_OBSERVER: {
                return CUMULATIVE_SUM;
            }
            case VALUE_RECORDER: {
                return SUMMARY;
            }
            case VALUE_OBSERVER: {
                return LAST_VALUE;
            }
        }
        throw new IllegalArgumentException("Unknown descriptor type: " + (Object)((Object)descriptor.getType()));
    }

    private static LinkedHashMap<Pattern, AggregatorFactory> newLinkedHashMap(Pattern pattern, AggregatorFactory aggregatorFactory, LinkedHashMap<Pattern, AggregatorFactory> parentConfiguration) {
        LinkedHashMap<Pattern, AggregatorFactory> result = new LinkedHashMap<Pattern, AggregatorFactory>();
        result.put(pattern, aggregatorFactory);
        result.putAll(parentConfiguration);
        return result;
    }
}

