/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.aggregator;

import io.opentelemetry.api.common.Labels;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.aggregator.AbstractSumAggregator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.aggregator.MetricDataUtils;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.DoubleSumData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Map;
import java.util.concurrent.atomic.DoubleAdder;

final class DoubleSumAggregator
extends AbstractSumAggregator<Double> {
    DoubleSumAggregator(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor descriptor, boolean stateful) {
        super(resource, instrumentationLibraryInfo, descriptor, stateful);
    }

    @Override
    public AggregatorHandle<Double> createHandle() {
        return new Handle();
    }

    @Override
    public Double accumulateDouble(double value) {
        return value;
    }

    @Override
    public final Double merge(Double a1, Double a2) {
        return a1 + a2;
    }

    @Override
    public MetricData toMetricData(Map<Labels, Double> accumulationByLabels, long startEpochNanos, long lastCollectionEpoch, long epochNanos) {
        return MetricData.createDoubleSum(this.getResource(), this.getInstrumentationLibraryInfo(), this.getInstrumentDescriptor().getName(), this.getInstrumentDescriptor().getDescription(), this.getInstrumentDescriptor().getUnit(), DoubleSumData.create(this.isMonotonic(), this.temporality(), MetricDataUtils.toDoublePointList(accumulationByLabels, this.temporality() == AggregationTemporality.CUMULATIVE ? startEpochNanos : lastCollectionEpoch, epochNanos)));
    }

    static final class Handle
    extends AggregatorHandle<Double> {
        private final DoubleAdder current = new DoubleAdder();

        Handle() {
        }

        @Override
        protected Double doAccumulateThenReset() {
            return this.current.sumThenReset();
        }

        @Override
        protected void doRecordDouble(double value) {
            this.current.add(value);
        }
    }
}

