/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.data;

import io.opentelemetry.api.common.Labels;
import io.opentelemetry.sdk.metrics.data.DoublePointData;

final class AutoValue_DoublePointData
extends DoublePointData {
    private final long startEpochNanos;
    private final long epochNanos;
    private final Labels labels;
    private final double value;

    AutoValue_DoublePointData(long startEpochNanos, long epochNanos, Labels labels, double value) {
        this.startEpochNanos = startEpochNanos;
        this.epochNanos = epochNanos;
        if (labels == null) {
            throw new NullPointerException("Null labels");
        }
        this.labels = labels;
        this.value = value;
    }

    @Override
    public long getStartEpochNanos() {
        return this.startEpochNanos;
    }

    @Override
    public long getEpochNanos() {
        return this.epochNanos;
    }

    @Override
    public Labels getLabels() {
        return this.labels;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    public String toString() {
        return "DoublePointData{startEpochNanos=" + this.startEpochNanos + ", epochNanos=" + this.epochNanos + ", labels=" + this.labels + ", value=" + this.value + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DoublePointData) {
            DoublePointData that = (DoublePointData)o;
            return this.startEpochNanos == that.getStartEpochNanos() && this.epochNanos == that.getEpochNanos() && this.labels.equals(that.getLabels()) && Double.doubleToLongBits(this.value) == Double.doubleToLongBits(that.getValue());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= (int)(this.startEpochNanos >>> 32 ^ this.startEpochNanos);
        h$ *= 1000003;
        h$ ^= (int)(this.epochNanos >>> 32 ^ this.epochNanos);
        h$ *= 1000003;
        h$ ^= this.labels.hashCode();
        h$ *= 1000003;
        return h$ ^= (int)(Double.doubleToLongBits(this.value) >>> 32 ^ Double.doubleToLongBits(this.value));
    }
}

