/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.metrics.AsynchronousInstrument;
import io.opentelemetry.sdk.metrics.AbstractAccumulator;
import io.opentelemetry.sdk.metrics.InstrumentProcessor;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import javax.annotation.Nullable;

final class AsynchronousInstrumentAccumulator
extends AbstractAccumulator {
    private final ReentrantLock collectLock = new ReentrantLock();
    private final InstrumentProcessor<?> instrumentProcessor;
    private final Runnable metricUpdater;

    static <T> AsynchronousInstrumentAccumulator doubleAsynchronousAccumulator(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, InstrumentDescriptor descriptor, @Nullable Consumer<AsynchronousInstrument.DoubleResult> metricUpdater) {
        Aggregator aggregator = AsynchronousInstrumentAccumulator.getAggregator(meterProviderSharedState, meterSharedState, descriptor);
        InstrumentProcessor instrumentProcessor = new InstrumentProcessor(aggregator, meterProviderSharedState.getStartEpochNanos());
        if (metricUpdater == null) {
            return new AsynchronousInstrumentAccumulator(instrumentProcessor, () -> {});
        }
        AsynchronousInstrument.DoubleResult result = (value, labels) -> instrumentProcessor.batch(labels, aggregator.accumulateDouble(value));
        return new AsynchronousInstrumentAccumulator(instrumentProcessor, () -> metricUpdater.accept(result));
    }

    static <T> AsynchronousInstrumentAccumulator longAsynchronousAccumulator(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, InstrumentDescriptor descriptor, @Nullable Consumer<AsynchronousInstrument.LongResult> metricUpdater) {
        Aggregator aggregator = AsynchronousInstrumentAccumulator.getAggregator(meterProviderSharedState, meterSharedState, descriptor);
        InstrumentProcessor instrumentProcessor = new InstrumentProcessor(aggregator, meterProviderSharedState.getStartEpochNanos());
        if (metricUpdater == null) {
            return new AsynchronousInstrumentAccumulator(instrumentProcessor, () -> {});
        }
        AsynchronousInstrument.LongResult result = (value, labels) -> instrumentProcessor.batch(labels, aggregator.accumulateLong(value));
        return new AsynchronousInstrumentAccumulator(instrumentProcessor, () -> metricUpdater.accept(result));
    }

    private AsynchronousInstrumentAccumulator(InstrumentProcessor<?> instrumentProcessor, Runnable metricUpdater) {
        this.instrumentProcessor = instrumentProcessor;
        this.metricUpdater = metricUpdater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<MetricData> collectAll(long epochNanos) {
        this.collectLock.lock();
        try {
            this.metricUpdater.run();
            List<MetricData> list = this.instrumentProcessor.completeCollectionCycle(epochNanos);
            return list;
        }
        finally {
            this.collectLock.unlock();
        }
    }
}

