/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.metrics.BatchRecorder;
import io.opentelemetry.api.metrics.DoubleCounter;
import io.opentelemetry.api.metrics.DoubleUpDownCounter;
import io.opentelemetry.api.metrics.DoubleValueRecorder;
import io.opentelemetry.api.metrics.Instrument;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.api.metrics.LongValueRecorder;
import io.opentelemetry.api.metrics.common.Labels;
import java.util.ArrayList;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TransferQueue;

final class BatchRecorderSdk
implements BatchRecorder {
    private final Labels labelSet;
    private final TransferQueue<Recording> pendingRecordings = new LinkedTransferQueue<Recording>();

    BatchRecorderSdk(String ... keyValuePairs) {
        this.labelSet = Labels.of((String[])keyValuePairs);
    }

    public BatchRecorder put(LongValueRecorder valueRecorder, long value) {
        this.pendingRecordings.offer(new LongRecording((Instrument)valueRecorder, value));
        return this;
    }

    public BatchRecorder put(DoubleValueRecorder valueRecorder, double value) {
        this.pendingRecordings.offer(new DoubleRecording((Instrument)valueRecorder, value));
        return this;
    }

    public BatchRecorder put(LongCounter counter, long value) {
        this.pendingRecordings.offer(new LongRecording((Instrument)counter, value));
        return this;
    }

    public BatchRecorder put(DoubleCounter counter, double value) {
        this.pendingRecordings.offer(new DoubleRecording((Instrument)counter, value));
        return this;
    }

    public BatchRecorder put(LongUpDownCounter upDownCounter, long value) {
        this.pendingRecordings.offer(new LongRecording((Instrument)upDownCounter, value));
        return this;
    }

    public BatchRecorder put(DoubleUpDownCounter upDownCounter, double value) {
        this.pendingRecordings.offer(new DoubleRecording((Instrument)upDownCounter, value));
        return this;
    }

    public void record() {
        ArrayList recordings = new ArrayList();
        this.pendingRecordings.drainTo(recordings);
        recordings.forEach(recording -> {
            Instrument instrument = recording.getInstrument();
            if (instrument instanceof DoubleUpDownCounter) {
                ((DoubleUpDownCounter)instrument).add(recording.getDoubleValue(), this.labelSet);
            } else if (instrument instanceof DoubleCounter) {
                ((DoubleCounter)instrument).add(recording.getDoubleValue(), this.labelSet);
            } else if (instrument instanceof DoubleValueRecorder) {
                ((DoubleValueRecorder)instrument).record(recording.getDoubleValue(), this.labelSet);
            } else if (instrument instanceof LongUpDownCounter) {
                ((LongUpDownCounter)instrument).add(recording.getLongValue(), this.labelSet);
            } else if (instrument instanceof LongCounter) {
                ((LongCounter)instrument).add(recording.getLongValue(), this.labelSet);
            } else if (instrument instanceof LongValueRecorder) {
                ((LongValueRecorder)instrument).record(recording.getLongValue(), this.labelSet);
            }
        });
    }

    private static class DoubleRecording
    implements Recording {
        private final Instrument instrument;
        private final double value;

        private DoubleRecording(Instrument instrument, double value) {
            this.instrument = instrument;
            this.value = value;
        }

        @Override
        public Instrument getInstrument() {
            return this.instrument;
        }

        @Override
        public long getLongValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getDoubleValue() {
            return this.value;
        }
    }

    private static class LongRecording
    implements Recording {
        private final Instrument instrument;
        private final long value;

        private LongRecording(Instrument instrument, long value) {
            this.instrument = instrument;
            this.value = value;
        }

        @Override
        public Instrument getInstrument() {
            return this.instrument;
        }

        @Override
        public long getLongValue() {
            return this.value;
        }

        @Override
        public double getDoubleValue() {
            throw new UnsupportedOperationException();
        }
    }

    private static interface Recording {
        public Instrument getInstrument();

        public long getLongValue();

        public double getDoubleValue();
    }
}

