/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.common.Labels;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.Batcher;
import io.opentelemetry.sdk.metrics.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.aggregator.NoopAggregator;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.view.Aggregation;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class Batchers {
    static Batcher getNoop() {
        return Noop.INSTANCE;
    }

    static Batcher getCumulativeAllLabels(InstrumentDescriptor descriptor, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, Aggregation aggregation) {
        return new AllLabels(descriptor, aggregation, meterProviderSharedState.getResource(), meterSharedState.getInstrumentationLibraryInfo(), meterProviderSharedState.getClock(), false);
    }

    static Batcher getDeltaAllLabels(InstrumentDescriptor descriptor, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, Aggregation aggregation) {
        return new AllLabels(descriptor, aggregation, meterProviderSharedState.getResource(), meterSharedState.getInstrumentationLibraryInfo(), meterProviderSharedState.getClock(), true);
    }

    private Batchers() {
    }

    private static final class AllLabels
    implements Batcher {
        private final InstrumentDescriptor descriptor;
        private final Aggregation aggregation;
        private final Resource resource;
        private final InstrumentationLibraryInfo instrumentationLibraryInfo;
        private final Clock clock;
        private final AggregatorFactory aggregatorFactory;
        private Map<Labels, Aggregator> aggregatorMap;
        private long startEpochNanos;
        private final boolean delta;

        private AllLabels(InstrumentDescriptor descriptor, Aggregation aggregation, Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, Clock clock, boolean delta) {
            this.descriptor = descriptor;
            this.aggregation = aggregation;
            this.resource = resource;
            this.instrumentationLibraryInfo = instrumentationLibraryInfo;
            this.clock = clock;
            this.aggregatorFactory = aggregation.getAggregatorFactory(descriptor.getValueType());
            this.delta = delta;
            this.aggregatorMap = new HashMap<Labels, Aggregator>();
            this.startEpochNanos = clock.now();
        }

        @Override
        public final Aggregator getAggregator() {
            return this.aggregatorFactory.getAggregator();
        }

        @Override
        public final void batch(Labels labelSet, Aggregator aggregator, boolean unmappedAggregator) {
            Aggregator currentAggregator = this.aggregatorMap.get(labelSet);
            if (currentAggregator == null) {
                if (unmappedAggregator) {
                    this.aggregatorMap.put(labelSet, aggregator);
                    return;
                }
                currentAggregator = this.aggregatorFactory.getAggregator();
                this.aggregatorMap.put(labelSet, currentAggregator);
            }
            aggregator.mergeToAndReset(currentAggregator);
        }

        @Override
        public final List<MetricData> completeCollectionCycle() {
            ArrayList<MetricData.Point> points = new ArrayList<MetricData.Point>(this.aggregatorMap.size());
            long epochNanos = this.clock.now();
            for (Map.Entry<Labels, Aggregator> entry : this.aggregatorMap.entrySet()) {
                MetricData.Point point = entry.getValue().toPoint(this.startEpochNanos, epochNanos, entry.getKey());
                if (point == null) continue;
                points.add(point);
            }
            if (this.delta) {
                this.startEpochNanos = epochNanos;
                this.aggregatorMap = new HashMap<Labels, Aggregator>();
            }
            return Collections.singletonList(MetricData.create(this.resource, this.instrumentationLibraryInfo, this.descriptor.getName(), this.descriptor.getDescription(), this.aggregation.getUnit(this.descriptor.getUnit()), this.aggregation.getDescriptorType(this.descriptor.getType(), this.descriptor.getValueType()), points));
        }
    }

    private static final class Noop
    implements Batcher {
        private static final Noop INSTANCE = new Noop();

        private Noop() {
        }

        @Override
        public Aggregator getAggregator() {
            return NoopAggregator.getFactory().getAggregator();
        }

        @Override
        public void batch(Labels labelSet, Aggregator aggregator, boolean mappedAggregator) {
        }

        @Override
        public List<MetricData> completeCollectionCycle() {
            return Collections.emptyList();
        }
    }
}

