/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.aggregator;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.opentelemetry.common.Labels;
import io.opentelemetry.sdk.metrics.aggregator.AbstractAggregator;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class DoubleMinMaxSumCount
extends AbstractAggregator {
    private static final AggregatorFactory AGGREGATOR_FACTORY = new AggregatorFactory(){

        @Override
        public Aggregator getAggregator() {
            return new DoubleMinMaxSumCount();
        }
    };
    private final DoubleSummary current = new DoubleSummary();

    public static AggregatorFactory getFactory() {
        return AGGREGATOR_FACTORY;
    }

    private DoubleMinMaxSumCount() {
    }

    @Override
    void doMergeAndReset(Aggregator target) {
        DoubleMinMaxSumCount other = (DoubleMinMaxSumCount)target;
        this.current.mergeAndReset(other.current);
    }

    @Override
    @Nullable
    public MetricData.Point toPoint(long startEpochNanos, long epochNanos, Labels labels) {
        return this.current.toPoint(startEpochNanos, epochNanos, labels);
    }

    @Override
    public void doRecordDouble(double value) {
        this.current.record(value);
    }

    private static final class DoubleSummary {
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        @GuardedBy(value="lock")
        private double sum = 0.0;
        @GuardedBy(value="lock")
        private long count = 0L;
        @GuardedBy(value="lock")
        private double min = Double.POSITIVE_INFINITY;
        @GuardedBy(value="lock")
        private double max = Double.NEGATIVE_INFINITY;

        private DoubleSummary() {
        }

        private void record(double value) {
            this.lock.writeLock().lock();
            try {
                ++this.count;
                this.sum += value;
                this.min = Math.min(value, this.min);
                this.max = Math.max(value, this.max);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mergeAndReset(DoubleSummary other) {
            double myMax;
            double myMin;
            double mySum;
            long myCount;
            this.lock.writeLock().lock();
            try {
                if (this.count == 0L) {
                    return;
                }
                myCount = this.count;
                mySum = this.sum;
                myMin = this.min;
                myMax = this.max;
                this.count = 0L;
                this.sum = 0.0;
                this.min = Double.POSITIVE_INFINITY;
                this.max = Double.NEGATIVE_INFINITY;
            }
            finally {
                this.lock.writeLock().unlock();
            }
            other.lock.writeLock().lock();
            try {
                other.count += myCount;
                other.sum += mySum;
                other.min = Math.min(myMin, other.min);
                other.max = Math.max(myMax, other.max);
            }
            finally {
                other.lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private MetricData.SummaryPoint toPoint(long startEpochNanos, long epochNanos, Labels labels) {
            this.lock.readLock().lock();
            try {
                MetricData.SummaryPoint summaryPoint = this.count == 0L ? null : MetricData.SummaryPoint.create(startEpochNanos, epochNanos, labels, this.count, this.sum, Arrays.asList(MetricData.ValueAtPercentile.create(0.0, this.min), MetricData.ValueAtPercentile.create(100.0, this.max)));
                return summaryPoint;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }
}

