/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.metrics.DoubleGaugeBuilder;
import io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import io.opentelemetry.api.metrics.LongCounterBuilder;
import io.opentelemetry.api.metrics.LongUpDownCounterBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.SdkDoubleGaugeBuilder;
import io.opentelemetry.sdk.metrics.SdkDoubleHistogram;
import io.opentelemetry.sdk.metrics.SdkLongCounter;
import io.opentelemetry.sdk.metrics.SdkLongUpDownCounter;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.export.CollectionInfo;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import java.util.Collection;

final class SdkMeter
implements Meter {
    private final MeterProviderSharedState meterProviderSharedState;
    private final MeterSharedState meterSharedState;

    SdkMeter(MeterProviderSharedState meterProviderSharedState, InstrumentationLibraryInfo instrumentationLibraryInfo) {
        this.meterProviderSharedState = meterProviderSharedState;
        this.meterSharedState = MeterSharedState.create(instrumentationLibraryInfo);
    }

    InstrumentationLibraryInfo getInstrumentationLibraryInfo() {
        return this.meterSharedState.getInstrumentationLibraryInfo();
    }

    Collection<MetricData> collectAll(CollectionInfo collectionInfo, long epochNanos, boolean suppressSynchronousCollection) {
        return this.meterSharedState.collectAll(collectionInfo, this.meterProviderSharedState, epochNanos, suppressSynchronousCollection);
    }

    public LongCounterBuilder counterBuilder(String name) {
        return new SdkLongCounter.Builder(this.meterProviderSharedState, this.meterSharedState, name);
    }

    public LongUpDownCounterBuilder upDownCounterBuilder(String name) {
        return new SdkLongUpDownCounter.Builder(this.meterProviderSharedState, this.meterSharedState, name);
    }

    public DoubleHistogramBuilder histogramBuilder(String name) {
        return new SdkDoubleHistogram.Builder(this.meterProviderSharedState, this.meterSharedState, name);
    }

    public DoubleGaugeBuilder gaugeBuilder(String name) {
        return new SdkDoubleGaugeBuilder(this.meterProviderSharedState, this.meterSharedState, name);
    }
}

