/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.sdk.internal.PrimitiveLongList;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramBuckets;
import io.opentelemetry.sdk.metrics.internal.aggregator.BucketMapper;
import io.opentelemetry.sdk.metrics.internal.state.ExponentialCounter;
import io.opentelemetry.sdk.metrics.internal.state.MapCounter;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class DoubleExponentialHistogramBuckets
implements ExponentialHistogramBuckets {
    public static final int MAX_SCALE = 20;
    private static final int MAX_BUCKETS = 320;
    private ExponentialCounter counts;
    private BucketMapper bucketMapper;
    private int scale;

    DoubleExponentialHistogramBuckets() {
        this.counts = new MapCounter();
        this.bucketMapper = new LogarithmMapper(20);
        this.scale = 20;
    }

    DoubleExponentialHistogramBuckets(DoubleExponentialHistogramBuckets buckets) {
        this.counts = new MapCounter(buckets.counts);
        this.bucketMapper = new LogarithmMapper(buckets.scale);
        this.scale = buckets.scale;
    }

    boolean record(double value) {
        if (value == 0.0) {
            throw new IllegalStateException("Illegal attempted recording of zero at bucket level.");
        }
        int index = this.bucketMapper.valueToIndex(Math.abs(value));
        return this.counts.increment(index, 1L);
    }

    @Override
    public int getOffset() {
        return this.counts.getIndexStart();
    }

    @Override
    @Nonnull
    public List<Long> getBucketCounts() {
        if (this.counts.isEmpty()) {
            return Collections.emptyList();
        }
        int length = this.counts.getIndexEnd() - this.counts.getIndexStart() + 1;
        long[] countsArr = new long[length];
        for (int i = 0; i < length; ++i) {
            countsArr[i] = this.counts.get(i + this.counts.getIndexStart());
        }
        return PrimitiveLongList.wrap((long[])countsArr);
    }

    @Override
    public long getTotalCount() {
        long totalCount = 0L;
        for (int i = this.counts.getIndexStart(); i <= this.counts.getIndexEnd(); ++i) {
            totalCount += this.counts.get(i);
        }
        return totalCount;
    }

    void downscale(int by) {
        if (by == 0) {
            return;
        }
        if (by < 0) {
            throw new IllegalStateException("Cannot downscale by negative amount. Was given " + by + ".");
        }
        if (!this.counts.isEmpty()) {
            MapCounter newCounts = new MapCounter();
            for (int i = this.counts.getIndexStart(); i <= this.counts.getIndexEnd(); ++i) {
                long count = this.counts.get(i);
                if (count <= 0L || newCounts.increment(i >> by, count)) continue;
                throw new IllegalStateException("Failed to create new downscaled buckets.");
            }
            this.counts = newCounts;
        }
        this.scale -= by;
        this.bucketMapper = new LogarithmMapper(this.scale);
    }

    static DoubleExponentialHistogramBuckets diff(DoubleExponentialHistogramBuckets a, DoubleExponentialHistogramBuckets b) {
        DoubleExponentialHistogramBuckets copy = new DoubleExponentialHistogramBuckets(a);
        copy.mergeWith(b, false);
        return copy;
    }

    static DoubleExponentialHistogramBuckets merge(DoubleExponentialHistogramBuckets a, DoubleExponentialHistogramBuckets b) {
        if (b.counts.isEmpty()) {
            return new DoubleExponentialHistogramBuckets(a);
        }
        if (a.counts.isEmpty()) {
            return new DoubleExponentialHistogramBuckets(b);
        }
        DoubleExponentialHistogramBuckets copy = new DoubleExponentialHistogramBuckets(a);
        copy.mergeWith(b, true);
        return copy;
    }

    private void mergeWith(DoubleExponentialHistogramBuckets other, boolean additive) {
        long newWindowEnd;
        long newWindowStart;
        if (other.counts.isEmpty()) {
            return;
        }
        int commonScale = Math.min(this.scale, other.scale);
        int deltaThis = this.scale - commonScale;
        int deltaOther = other.scale - commonScale;
        if (this.counts.isEmpty()) {
            newWindowStart = other.getOffset() >> deltaOther;
            newWindowEnd = other.counts.getIndexEnd() >> deltaOther;
        } else {
            newWindowStart = Math.min(this.getOffset() >> deltaThis, other.getOffset() >> deltaOther);
            newWindowEnd = Math.max(this.counts.getIndexEnd() >> deltaThis, other.counts.getIndexEnd() >> deltaOther);
        }
        this.downscale(deltaThis += this.getScaleReduction(newWindowStart, newWindowEnd));
        deltaOther = other.scale - this.scale;
        int sign = additive ? 1 : -1;
        for (int i = other.getOffset(); i <= other.counts.getIndexEnd(); ++i) {
            if (this.counts.increment(i >> deltaOther, (long)sign * other.counts.get(i))) continue;
            throw new IllegalStateException("Failed to merge exponential histogram buckets.");
        }
    }

    int getScale() {
        return this.scale;
    }

    int getScaleReduction(double value) {
        long index = this.bucketMapper.valueToIndex(Math.abs(value));
        long newStart = Math.min(index, (long)this.counts.getIndexStart());
        long newEnd = Math.max(index, (long)this.counts.getIndexEnd());
        return this.getScaleReduction(newStart, newEnd);
    }

    int getScaleReduction(long newStart, long newEnd) {
        int scaleReduction = 0;
        while (newEnd - newStart + 1L > 320L) {
            newStart >>= 1;
            newEnd >>= 1;
            ++scaleReduction;
        }
        return scaleReduction;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof DoubleExponentialHistogramBuckets)) {
            return false;
        }
        DoubleExponentialHistogramBuckets other = (DoubleExponentialHistogramBuckets)obj;
        return this.getBucketCounts().equals(other.getBucketCounts()) && this.getOffset() == other.getOffset() && this.scale == other.scale;
    }

    public int hashCode() {
        int hash = 1;
        hash *= 1000003;
        hash ^= this.getOffset();
        hash *= 1000003;
        hash ^= this.getBucketCounts().hashCode();
        hash *= 1000003;
        return hash ^= this.scale;
    }

    public String toString() {
        return "DoubleExponentialHistogramBuckets{scale: " + this.scale + ", offset: " + this.getOffset() + ", counts: " + this.counts + " }";
    }

    private static class LogarithmMapper
    implements BucketMapper {
        private final double scaleFactor;

        LogarithmMapper(int scale) {
            this.scaleFactor = Math.scalb(1.0 / Math.log(2.0), scale);
        }

        @Override
        public int valueToIndex(double value) {
            return (int)Math.floor(Math.log(value) * this.scaleFactor);
        }
    }
}

