/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.testing;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class InMemoryMetricExporter
implements MetricExporter {
    private final Queue<MetricData> finishedMetricItems = new ConcurrentLinkedQueue<MetricData>();
    private final AggregationTemporality preferredTemporality;
    private boolean isStopped = false;

    private InMemoryMetricExporter(AggregationTemporality preferredTemporality) {
        this.preferredTemporality = preferredTemporality;
    }

    public static InMemoryMetricExporter create() {
        return InMemoryMetricExporter.create(AggregationTemporality.CUMULATIVE);
    }

    public static InMemoryMetricExporter create(AggregationTemporality preferredTemporality) {
        return new InMemoryMetricExporter(preferredTemporality);
    }

    public List<MetricData> getFinishedMetricItems() {
        return Collections.unmodifiableList(new ArrayList<MetricData>(this.finishedMetricItems));
    }

    public void reset() {
        this.finishedMetricItems.clear();
    }

    @Override
    public AggregationTemporality getPreferredTemporality() {
        return this.preferredTemporality;
    }

    @Override
    public CompletableResultCode export(Collection<MetricData> metrics) {
        if (this.isStopped) {
            return CompletableResultCode.ofFailure();
        }
        this.finishedMetricItems.addAll(metrics);
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        this.isStopped = true;
        this.finishedMetricItems.clear();
        return CompletableResultCode.ofSuccess();
    }
}

