/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.LongSumData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarReservoir;
import io.opentelemetry.sdk.metrics.internal.aggregator.AbstractSumAggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.aggregator.LongAccumulation;
import io.opentelemetry.sdk.metrics.internal.aggregator.MetricDataUtils;
import io.opentelemetry.sdk.metrics.internal.concurrent.AdderUtil;
import io.opentelemetry.sdk.metrics.internal.concurrent.LongAdder;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.resources.Resource;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public final class LongSumAggregator
extends AbstractSumAggregator<LongAccumulation> {
    private final Supplier<ExemplarReservoir> reservoirSupplier;

    public LongSumAggregator(InstrumentDescriptor instrumentDescriptor, Supplier<ExemplarReservoir> reservoirSupplier) {
        super(instrumentDescriptor);
        this.reservoirSupplier = reservoirSupplier;
    }

    @Override
    public AggregatorHandle<LongAccumulation> createHandle() {
        return new Handle(this.reservoirSupplier.get());
    }

    @Override
    public LongAccumulation merge(LongAccumulation previousAccumulation, LongAccumulation accumulation) {
        return LongAccumulation.create(previousAccumulation.getValue() + accumulation.getValue(), accumulation.getExemplars());
    }

    @Override
    public LongAccumulation diff(LongAccumulation previousAccumulation, LongAccumulation accumulation) {
        return LongAccumulation.create(accumulation.getValue() - previousAccumulation.getValue(), accumulation.getExemplars());
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, MetricDescriptor descriptor, Map<Attributes, LongAccumulation> accumulationByLabels, AggregationTemporality temporality, long startEpochNanos, long lastCollectionEpoch, long epochNanos) {
        return MetricData.createLongSum(resource, instrumentationLibraryInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getUnit(), LongSumData.create(this.isMonotonic(), temporality, MetricDataUtils.toLongPointList(accumulationByLabels, temporality == AggregationTemporality.CUMULATIVE ? startEpochNanos : lastCollectionEpoch, epochNanos)));
    }

    static final class Handle
    extends AggregatorHandle<LongAccumulation> {
        private final LongAdder current = AdderUtil.createLongAdder();

        Handle(ExemplarReservoir exemplarReservoir) {
            super(exemplarReservoir);
        }

        @Override
        protected LongAccumulation doAccumulateThenReset(List<ExemplarData> exemplars) {
            return LongAccumulation.create(this.current.sumThenReset(), exemplars);
        }

        @Override
        public void doRecordLong(long value) {
            this.current.add(value);
        }
    }
}

