/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.descriptor;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;
import io.opentelemetry.sdk.metrics.internal.descriptor.AutoValue_MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.view.View;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
public abstract class MetricDescriptor {
    public static MetricDescriptor create(String name, String description, String unit) {
        return new AutoValue_MetricDescriptor(name, description, unit, Optional.empty(), InstrumentDescriptor.create(name, description, unit, InstrumentType.OBSERVABLE_GAUGE, InstrumentValueType.DOUBLE));
    }

    public static MetricDescriptor create(View view, InstrumentDescriptor instrument) {
        String name = view.getName() == null ? instrument.getName() : view.getName();
        String description = view.getDescription() == null ? instrument.getDescription() : view.getDescription();
        return new AutoValue_MetricDescriptor(name, description, instrument.getUnit(), Optional.of(view), instrument);
    }

    public abstract String getName();

    public abstract String getDescription();

    public abstract String getUnit();

    public abstract Optional<View> getSourceView();

    public abstract InstrumentDescriptor getSourceInstrument();

    @Memoized
    public abstract int hashCode();

    public boolean isCompatibleWith(MetricDescriptor other) {
        return Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getDescription(), other.getDescription()) && Objects.equals(this.getUnit(), other.getUnit()) && Objects.equals((Object)this.getSourceInstrument().getType(), (Object)other.getSourceInstrument().getType()) && Objects.equals((Object)this.getSourceInstrument().getValueType(), (Object)other.getSourceInstrument().getValueType());
    }

    public boolean isAsync() {
        switch (this.getSourceInstrument().getType()) {
            case OBSERVABLE_UP_DOWN_SUM: 
            case OBSERVABLE_UP_DOWN_COUNTER: 
            case OBSERVABLE_GAUGE: 
            case OBSERVABLE_SUM: 
            case OBSERVABLE_COUNTER: {
                return true;
            }
            case HISTOGRAM: 
            case COUNTER: 
            case UP_DOWN_COUNTER: {
                return false;
            }
        }
        throw new IllegalStateException("Unrecognized instrument type " + (Object)((Object)this.getSourceInstrument().getType()));
    }
}

