/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.view;

import io.opentelemetry.sdk.metrics.exemplar.ExemplarFilter;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.view.DefaultAggregation;
import io.opentelemetry.sdk.metrics.view.DropAggregation;
import io.opentelemetry.sdk.metrics.view.ExplicitBucketHistogramAggregation;
import io.opentelemetry.sdk.metrics.view.LastValueAggregation;
import io.opentelemetry.sdk.metrics.view.SumAggregation;
import java.util.List;

public abstract class Aggregation {
    Aggregation() {
    }

    public abstract <T> Aggregator<T> createAggregator(InstrumentDescriptor var1, ExemplarFilter var2);

    public static Aggregation drop() {
        return DropAggregation.INSTANCE;
    }

    public static Aggregation defaultAggregation() {
        return DefaultAggregation.INSTANCE;
    }

    public static Aggregation sum() {
        return SumAggregation.DEFAULT;
    }

    public static Aggregation lastValue() {
        return LastValueAggregation.INSTANCE;
    }

    public static Aggregation explicitBucketHistogram() {
        return ExplicitBucketHistogramAggregation.DEFAULT;
    }

    public static Aggregation explicitBucketHistogram(List<Double> bucketBoundaries) {
        return new ExplicitBucketHistogramAggregation(bucketBoundaries);
    }

    public static Aggregation histogram() {
        return Aggregation.explicitBucketHistogram();
    }
}

