/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.view;

import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarFilter;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.view.Aggregation;
import io.opentelemetry.sdk.metrics.view.DropAggregation;
import io.opentelemetry.sdk.metrics.view.ExplicitBucketHistogramAggregation;
import io.opentelemetry.sdk.metrics.view.LastValueAggregation;
import io.opentelemetry.sdk.metrics.view.SumAggregation;
import java.util.logging.Level;
import java.util.logging.Logger;

class DefaultAggregation
extends Aggregation {
    static final Aggregation INSTANCE = new DefaultAggregation();
    private static final ThrottlingLogger logger = new ThrottlingLogger(Logger.getLogger(DefaultAggregation.class.getName()));

    private DefaultAggregation() {
    }

    private static Aggregation resolve(InstrumentDescriptor instrument) {
        switch (instrument.getType()) {
            case COUNTER: 
            case UP_DOWN_COUNTER: 
            case OBSERVABLE_SUM: 
            case OBSERVABLE_COUNTER: 
            case OBSERVABLE_UP_DOWN_SUM: 
            case OBSERVABLE_UP_DOWN_COUNTER: {
                return SumAggregation.DEFAULT;
            }
            case HISTOGRAM: {
                return ExplicitBucketHistogramAggregation.DEFAULT;
            }
            case OBSERVABLE_GAUGE: {
                return LastValueAggregation.INSTANCE;
            }
        }
        logger.log(Level.WARNING, "Unable to find default aggregation for instrument: " + instrument);
        return DropAggregation.INSTANCE;
    }

    @Override
    public <T> Aggregator<T> createAggregator(InstrumentDescriptor instrumentDescriptor, ExemplarFilter exemplarFilter) {
        return DefaultAggregation.resolve(instrumentDescriptor).createAggregator(instrumentDescriptor, exemplarFilter);
    }

    public String toString() {
        return "DefaultAggregation";
    }
}

