/*
 * Copyright The OpenTelemetry Authors
 * SPDX-License-Identifier: Apache-2.0
 */

package io.opentelemetry.sdk.metrics.view;

import com.google.auto.value.AutoValue;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;

/**
 * Provides means for selecting one or more Meters. Used for selecting instruments when constructing
 * views.
 */
@AutoValue
@Immutable
public abstract class MeterSelector {

  /** Returns a new {@link MeterSelectorBuilder} for {@link InstrumentSelector}. */
  public static MeterSelectorBuilder builder() {
    return new MeterSelectorBuilder();
  }

  static MeterSelector create(
      Predicate<String> nameFilter,
      Predicate<String> versionFilter,
      Predicate<String> schemaUrlFilter) {
    return new AutoValue_MeterSelector(nameFilter, versionFilter, schemaUrlFilter);
  }

  /**
   * Returns the {@link Pattern} generated by the provided {@code regex} in the {@link
   * MeterSelectorBuilder}, or {@code Pattern.compile(".*")} if none was specified.
   */
  public abstract Predicate<String> getNameFilter();

  /**
   * Returns the {@link Pattern} generated by the provided {@code regex} in the {@link
   * MeterSelectorBuilder}, or {@code Pattern.compile(".*")} if none was specified.
   */
  public abstract Predicate<String> getVersionFilter();

  /**
   * Returns the {@link Pattern} generated by the provided {@code regex} in the {@link
   * MeterSelectorBuilder}, or {@code Pattern.compile(".*")} if none was specified.
   */
  public abstract Predicate<String> getSchemaUrlFilter();
}
