/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.export;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.io.Closeable;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public interface MetricExporter
extends Closeable {
    public static AggregationTemporality alwaysCumulative(InstrumentType unused) {
        return AggregationTemporality.CUMULATIVE;
    }

    public static AggregationTemporality deltaPreferred(InstrumentType instrumentType) {
        switch (instrumentType) {
            case UP_DOWN_COUNTER: 
            case OBSERVABLE_UP_DOWN_COUNTER: {
                return AggregationTemporality.CUMULATIVE;
            }
        }
        return AggregationTemporality.DELTA;
    }

    public AggregationTemporality getAggregationTemporality(InstrumentType var1);

    public CompletableResultCode export(Collection<MetricData> var1);

    public CompletableResultCode flush();

    public CompletableResultCode shutdown();

    @Override
    default public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }
}

