/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.internal.aggregator.DoubleExponentialHistogramBuckets;
import io.opentelemetry.sdk.metrics.internal.aggregator.ExponentialHistogramAccumulation;
import java.util.List;

final class AutoValue_ExponentialHistogramAccumulation
extends ExponentialHistogramAccumulation {
    private final int scale;
    private final double sum;
    private final DoubleExponentialHistogramBuckets positiveBuckets;
    private final DoubleExponentialHistogramBuckets negativeBuckets;
    private final long zeroCount;
    private final List<DoubleExemplarData> exemplars;

    AutoValue_ExponentialHistogramAccumulation(int scale, double sum, DoubleExponentialHistogramBuckets positiveBuckets, DoubleExponentialHistogramBuckets negativeBuckets, long zeroCount, List<DoubleExemplarData> exemplars) {
        this.scale = scale;
        this.sum = sum;
        if (positiveBuckets == null) {
            throw new NullPointerException("Null positiveBuckets");
        }
        this.positiveBuckets = positiveBuckets;
        if (negativeBuckets == null) {
            throw new NullPointerException("Null negativeBuckets");
        }
        this.negativeBuckets = negativeBuckets;
        this.zeroCount = zeroCount;
        if (exemplars == null) {
            throw new NullPointerException("Null exemplars");
        }
        this.exemplars = exemplars;
    }

    @Override
    int getScale() {
        return this.scale;
    }

    @Override
    double getSum() {
        return this.sum;
    }

    @Override
    DoubleExponentialHistogramBuckets getPositiveBuckets() {
        return this.positiveBuckets;
    }

    @Override
    DoubleExponentialHistogramBuckets getNegativeBuckets() {
        return this.negativeBuckets;
    }

    @Override
    long getZeroCount() {
        return this.zeroCount;
    }

    @Override
    List<DoubleExemplarData> getExemplars() {
        return this.exemplars;
    }

    public String toString() {
        return "ExponentialHistogramAccumulation{scale=" + this.scale + ", sum=" + this.sum + ", positiveBuckets=" + this.positiveBuckets + ", negativeBuckets=" + this.negativeBuckets + ", zeroCount=" + this.zeroCount + ", exemplars=" + this.exemplars + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ExponentialHistogramAccumulation) {
            ExponentialHistogramAccumulation that = (ExponentialHistogramAccumulation)o;
            return this.scale == that.getScale() && Double.doubleToLongBits(this.sum) == Double.doubleToLongBits(that.getSum()) && this.positiveBuckets.equals(that.getPositiveBuckets()) && this.negativeBuckets.equals(that.getNegativeBuckets()) && this.zeroCount == that.getZeroCount() && this.exemplars.equals(that.getExemplars());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.scale;
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.sum) >>> 32 ^ Double.doubleToLongBits(this.sum));
        h$ *= 1000003;
        h$ ^= this.positiveBuckets.hashCode();
        h$ *= 1000003;
        h$ ^= this.negativeBuckets.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.zeroCount >>> 32 ^ this.zeroCount);
        h$ *= 1000003;
        return h$ ^= this.exemplars.hashCode();
    }
}

