/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.aggregator.DoubleExponentialHistogramBuckets;
import io.opentelemetry.sdk.metrics.internal.aggregator.ExponentialBucketStrategy;
import io.opentelemetry.sdk.metrics.internal.aggregator.ExponentialHistogramAccumulation;
import io.opentelemetry.sdk.metrics.internal.aggregator.MetricDataUtils;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import io.opentelemetry.sdk.metrics.internal.data.exponentialhistogram.ExponentialHistogramData;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import io.opentelemetry.sdk.metrics.internal.state.ExponentialCounterFactory;
import io.opentelemetry.sdk.resources.Resource;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public final class DoubleExponentialHistogramAggregator
implements Aggregator<ExponentialHistogramAccumulation, DoubleExemplarData> {
    private final Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier;
    private final ExponentialBucketStrategy bucketStrategy;

    public DoubleExponentialHistogramAggregator(Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier, int scale, int maxBuckets) {
        this(reservoirSupplier, ExponentialBucketStrategy.newStrategy(scale, maxBuckets, ExponentialCounterFactory.circularBufferCounter()));
    }

    DoubleExponentialHistogramAggregator(Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier, ExponentialBucketStrategy bucketStrategy) {
        this.reservoirSupplier = reservoirSupplier;
        this.bucketStrategy = bucketStrategy;
    }

    @Override
    public AggregatorHandle<ExponentialHistogramAccumulation, DoubleExemplarData> createHandle() {
        return new Handle(this.reservoirSupplier.get(), this.bucketStrategy);
    }

    @Override
    public ExponentialHistogramAccumulation merge(ExponentialHistogramAccumulation previousAccumulation, ExponentialHistogramAccumulation delta) {
        double sum = previousAccumulation.getSum() + delta.getSum();
        long zeroCount = previousAccumulation.getZeroCount() + delta.getZeroCount();
        DoubleExponentialHistogramBuckets posBuckets = DoubleExponentialHistogramBuckets.merge(previousAccumulation.getPositiveBuckets(), delta.getPositiveBuckets());
        DoubleExponentialHistogramBuckets negBuckets = DoubleExponentialHistogramBuckets.merge(previousAccumulation.getNegativeBuckets(), delta.getNegativeBuckets());
        int commonScale = Math.min(posBuckets.getScale(), negBuckets.getScale());
        posBuckets.downscale(posBuckets.getScale() - commonScale);
        negBuckets.downscale(negBuckets.getScale() - commonScale);
        return ExponentialHistogramAccumulation.create(posBuckets.getScale(), sum, posBuckets, negBuckets, zeroCount, delta.getExemplars());
    }

    @Override
    public ExponentialHistogramAccumulation diff(ExponentialHistogramAccumulation previousCumulative, ExponentialHistogramAccumulation currentCumulative) {
        double sum = currentCumulative.getSum() - previousCumulative.getSum();
        long zeroCount = currentCumulative.getZeroCount() - previousCumulative.getZeroCount();
        DoubleExponentialHistogramBuckets posBuckets = DoubleExponentialHistogramBuckets.diff(currentCumulative.getPositiveBuckets(), previousCumulative.getPositiveBuckets());
        DoubleExponentialHistogramBuckets negBuckets = DoubleExponentialHistogramBuckets.diff(currentCumulative.getNegativeBuckets(), previousCumulative.getNegativeBuckets());
        int commonScale = Math.min(posBuckets.getScale(), negBuckets.getScale());
        posBuckets.downscale(posBuckets.getScale() - commonScale);
        negBuckets.downscale(negBuckets.getScale() - commonScale);
        return ExponentialHistogramAccumulation.create(posBuckets.getScale(), sum, posBuckets, negBuckets, zeroCount, currentCumulative.getExemplars());
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor metricDescriptor, Map<Attributes, ExponentialHistogramAccumulation> accumulationByLabels, AggregationTemporality temporality, long startEpochNanos, long lastCollectionEpoch, long epochNanos) {
        return ImmutableMetricData.createExponentialHistogram(resource, instrumentationScopeInfo, metricDescriptor.getName(), metricDescriptor.getDescription(), metricDescriptor.getSourceInstrument().getUnit(), ExponentialHistogramData.create(temporality, MetricDataUtils.toExponentialHistogramPointList(accumulationByLabels, temporality == AggregationTemporality.CUMULATIVE ? startEpochNanos : lastCollectionEpoch, epochNanos)));
    }

    static final class Handle
    extends AggregatorHandle<ExponentialHistogramAccumulation, DoubleExemplarData> {
        private final DoubleExponentialHistogramBuckets positiveBuckets;
        private final DoubleExponentialHistogramBuckets negativeBuckets;
        private long zeroCount = 0L;
        private double sum = 0.0;

        Handle(ExemplarReservoir<DoubleExemplarData> reservoir, ExponentialBucketStrategy bucketStrategy) {
            super(reservoir);
            this.positiveBuckets = bucketStrategy.newBuckets();
            this.negativeBuckets = bucketStrategy.newBuckets();
        }

        @Override
        protected synchronized ExponentialHistogramAccumulation doAccumulateThenReset(List<DoubleExemplarData> exemplars) {
            ExponentialHistogramAccumulation acc = ExponentialHistogramAccumulation.create(this.positiveBuckets.getScale(), this.sum, this.positiveBuckets.copy(), this.negativeBuckets.copy(), this.zeroCount, exemplars);
            this.sum = 0.0;
            this.zeroCount = 0L;
            this.positiveBuckets.clear();
            this.negativeBuckets.clear();
            return acc;
        }

        @Override
        protected synchronized void doRecordDouble(double value) {
            DoubleExponentialHistogramBuckets buckets;
            if (!Double.isFinite(value)) {
                return;
            }
            this.sum += value;
            int c = Double.compare(value, 0.0);
            if (c == 0) {
                ++this.zeroCount;
                return;
            }
            DoubleExponentialHistogramBuckets doubleExponentialHistogramBuckets = buckets = c > 0 ? this.positiveBuckets : this.negativeBuckets;
            if (!buckets.record(value)) {
                this.downScale(buckets.getScaleReduction(value));
                buckets.record(value);
            }
        }

        @Override
        protected void doRecordLong(long value) {
            this.doRecordDouble(value);
        }

        void downScale(int by) {
            this.positiveBuckets.downscale(by);
            this.negativeBuckets.downscale(by);
        }
    }
}

