/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.export;

import io.opentelemetry.sdk.metrics.export.MetricReader;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public class RegisteredReader {
    private static final AtomicInteger ID_COUNTER = new AtomicInteger(1);
    private final int id = ID_COUNTER.incrementAndGet();
    private final MetricReader metricReader;
    private volatile long lastCollectEpochNanos;

    public static RegisteredReader create(MetricReader reader) {
        return new RegisteredReader(reader);
    }

    private RegisteredReader(MetricReader metricReader) {
        this.metricReader = metricReader;
    }

    public MetricReader getReader() {
        return this.metricReader;
    }

    public void setLastCollectEpochNanos(long epochNanos) {
        this.lastCollectEpochNanos = epochNanos;
    }

    public long getLastCollectEpochNanos() {
        return this.lastCollectEpochNanos;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegisteredReader)) {
            return false;
        }
        return this.id == ((RegisteredReader)o).id;
    }

    public String toString() {
        return "RegisteredReader{" + this.id + "}";
    }
}

