/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.metrics.BoundLongCounter;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongCounterBuilder;
import io.opentelemetry.api.metrics.common.Labels;
import io.opentelemetry.sdk.metrics.AbstractSynchronousInstrument;
import io.opentelemetry.sdk.metrics.AbstractSynchronousInstrumentBuilder;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.SynchronousInstrumentAccumulator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;

final class LongCounterSdk
extends AbstractSynchronousInstrument
implements LongCounter {
    private LongCounterSdk(InstrumentDescriptor descriptor, SynchronousInstrumentAccumulator<?> accumulator) {
        super(descriptor, accumulator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long increment, Labels labels) {
        AggregatorHandle<?> aggregatorHandle = this.acquireHandle(labels);
        try {
            if (increment < 0L) {
                throw new IllegalArgumentException("Counters can only increase");
            }
            aggregatorHandle.recordLong(increment);
        }
        finally {
            aggregatorHandle.release();
        }
    }

    public void add(long increment) {
        this.add(increment, Labels.empty());
    }

    public BoundLongCounter bind(Labels labels) {
        return new BoundInstrument(this.acquireHandle(labels));
    }

    static final class Builder
    extends AbstractSynchronousInstrumentBuilder<Builder>
    implements LongCounterBuilder {
        Builder(String name, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
            super(name, InstrumentType.COUNTER, InstrumentValueType.LONG, meterProviderSharedState, meterSharedState);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public LongCounterSdk build() {
            return this.buildInstrument((x$0, x$1) -> new LongCounterSdk((InstrumentDescriptor)x$0, (SynchronousInstrumentAccumulator)x$1));
        }
    }

    static final class BoundInstrument
    implements BoundLongCounter {
        private final AggregatorHandle<?> aggregatorHandle;

        BoundInstrument(AggregatorHandle<?> aggregatorHandle) {
            this.aggregatorHandle = aggregatorHandle;
        }

        public void add(long increment) {
            if (increment < 0L) {
                throw new IllegalArgumentException("Counters can only increase");
            }
            this.aggregatorHandle.recordLong(increment);
        }

        public void unbind() {
            this.aggregatorHandle.release();
        }
    }
}

