/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.internal.ThrowableUtil;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.export.RegisteredReader;
import io.opentelemetry.sdk.metrics.internal.state.SdkObservableMeasurement;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class CallbackRegistration {
    private static final Logger logger = Logger.getLogger(CallbackRegistration.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final List<SdkObservableMeasurement> observableMeasurements;
    private final Runnable callback;
    private final String callbackDescription;
    private final boolean hasStorages;

    private CallbackRegistration(List<SdkObservableMeasurement> observableMeasurements, Runnable callback) {
        this.observableMeasurements = observableMeasurements;
        this.callback = callback;
        List<InstrumentDescriptor> instrumentDescriptors = observableMeasurements.stream().map(SdkObservableMeasurement::getInstrumentDescriptor).collect(Collectors.toList());
        this.callbackDescription = CallbackRegistration.callbackDescription(instrumentDescriptors);
        this.hasStorages = observableMeasurements.stream().flatMap(measurement -> measurement.getStorages().stream()).findAny().isPresent();
    }

    public static CallbackRegistration create(List<SdkObservableMeasurement> observableMeasurements, Runnable runnable) {
        return new CallbackRegistration(observableMeasurements, runnable);
    }

    static String callbackDescription(List<InstrumentDescriptor> instrumentDescriptors) {
        if (instrumentDescriptors.size() == 0) {
            throw new IllegalStateException("Callback with no instruments is not allowed");
        }
        if (instrumentDescriptors.size() == 1) {
            return "Instrument " + instrumentDescriptors.get(0).getName();
        }
        StringBuilder description = new StringBuilder("BatchCallback(");
        description.append(instrumentDescriptors.stream().map(InstrumentDescriptor::getName).collect(Collectors.joining(",", "[", "]")));
        return description.append(")").toString();
    }

    public String getCallbackDescription() {
        return this.callbackDescription;
    }

    void invokeCallback(RegisteredReader reader) {
        if (!this.hasStorages) {
            return;
        }
        this.observableMeasurements.forEach(observableMeasurement -> observableMeasurement.setActiveReader(reader));
        try {
            this.callback.run();
        }
        catch (Throwable e) {
            ThrowableUtil.propagateIfFatal((Throwable)e);
            this.throttlingLogger.log(Level.WARNING, "An exception occurred invoking callback for " + this.callbackDescription + ".", e);
        }
        finally {
            this.observableMeasurements.forEach(observableMeasurement -> observableMeasurement.setActiveReader(null));
        }
    }
}

