/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.LongHistogramBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.AbstractInstrumentBuilder;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.InstrumentValueType;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.logging.Level;
import java.util.logging.Logger;

final class SdkLongHistogram
extends AbstractInstrument
implements LongHistogram {
    private static final Logger logger = Logger.getLogger(SdkLongHistogram.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final WriteableMetricStorage storage;

    private SdkLongHistogram(InstrumentDescriptor descriptor, WriteableMetricStorage storage) {
        super(descriptor);
        this.storage = storage;
    }

    public void record(long value, Attributes attributes, Context context) {
        if (value < 0L) {
            this.throttlingLogger.log(Level.WARNING, "Histograms can only record non-negative values. Instrument " + this.getDescriptor().getName() + " has recorded a negative value.");
            return;
        }
        this.storage.recordLong(value, attributes, context);
    }

    public void record(long value, Attributes attributes) {
        this.record(value, attributes, Context.current());
    }

    public void record(long value) {
        this.record(value, Attributes.empty());
    }

    static final class SdkLongHistogramBuilder
    extends AbstractInstrumentBuilder<SdkLongHistogramBuilder>
    implements LongHistogramBuilder {
        SdkLongHistogramBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState sharedState, String name, String description, String unit) {
            super(meterProviderSharedState, sharedState, InstrumentType.HISTOGRAM, InstrumentValueType.LONG, name, description, unit);
        }

        @Override
        protected SdkLongHistogramBuilder getThis() {
            return this;
        }

        public SdkLongHistogram build() {
            return this.buildSynchronousInstrument((x$0, x$1) -> new SdkLongHistogram((InstrumentDescriptor)x$0, (WriteableMetricStorage)x$1));
        }
    }
}

