/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.BatchRecorderSdk;
import io.opentelemetry.sdk.metrics.DoubleCounterSdk;
import io.opentelemetry.sdk.metrics.DoubleSumObserverSdk;
import io.opentelemetry.sdk.metrics.DoubleUpDownCounterSdk;
import io.opentelemetry.sdk.metrics.DoubleUpDownSumObserverSdk;
import io.opentelemetry.sdk.metrics.DoubleValueObserverSdk;
import io.opentelemetry.sdk.metrics.DoubleValueRecorderSdk;
import io.opentelemetry.sdk.metrics.InstrumentRegistry;
import io.opentelemetry.sdk.metrics.LongCounterSdk;
import io.opentelemetry.sdk.metrics.LongSumObserverSdk;
import io.opentelemetry.sdk.metrics.LongUpDownCounterSdk;
import io.opentelemetry.sdk.metrics.LongUpDownSumObserverSdk;
import io.opentelemetry.sdk.metrics.LongValueObserverSdk;
import io.opentelemetry.sdk.metrics.LongValueRecorderSdk;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.util.ArrayList;
import java.util.Collection;

final class SdkMeter
implements Meter {
    private final MeterProviderSharedState meterProviderSharedState;
    private final MeterSharedState meterSharedState;

    SdkMeter(MeterProviderSharedState meterProviderSharedState, InstrumentationLibraryInfo instrumentationLibraryInfo) {
        this.meterProviderSharedState = meterProviderSharedState;
        this.meterSharedState = MeterSharedState.create(instrumentationLibraryInfo);
    }

    InstrumentationLibraryInfo getInstrumentationLibraryInfo() {
        return this.meterSharedState.getInstrumentationLibraryInfo();
    }

    public DoubleCounterSdk.Builder doubleCounterBuilder(String name) {
        return new DoubleCounterSdk.Builder(name, this.meterProviderSharedState, this.meterSharedState);
    }

    public LongCounterSdk.Builder longCounterBuilder(String name) {
        return new LongCounterSdk.Builder(name, this.meterProviderSharedState, this.meterSharedState);
    }

    public DoubleUpDownCounterSdk.Builder doubleUpDownCounterBuilder(String name) {
        return new DoubleUpDownCounterSdk.Builder(name, this.meterProviderSharedState, this.meterSharedState);
    }

    public LongUpDownCounterSdk.Builder longUpDownCounterBuilder(String name) {
        return new LongUpDownCounterSdk.Builder(name, this.meterProviderSharedState, this.meterSharedState);
    }

    public DoubleValueRecorderSdk.Builder doubleValueRecorderBuilder(String name) {
        return new DoubleValueRecorderSdk.Builder(name, this.meterProviderSharedState, this.meterSharedState);
    }

    public LongValueRecorderSdk.Builder longValueRecorderBuilder(String name) {
        return new LongValueRecorderSdk.Builder(name, this.meterProviderSharedState, this.meterSharedState);
    }

    public DoubleSumObserverSdk.Builder doubleSumObserverBuilder(String name) {
        return new DoubleSumObserverSdk.Builder(name, this.meterProviderSharedState, this.meterSharedState);
    }

    public LongSumObserverSdk.Builder longSumObserverBuilder(String name) {
        return new LongSumObserverSdk.Builder(name, this.meterProviderSharedState, this.meterSharedState);
    }

    public DoubleUpDownSumObserverSdk.Builder doubleUpDownSumObserverBuilder(String name) {
        return new DoubleUpDownSumObserverSdk.Builder(name, this.meterProviderSharedState, this.meterSharedState);
    }

    public LongUpDownSumObserverSdk.Builder longUpDownSumObserverBuilder(String name) {
        return new LongUpDownSumObserverSdk.Builder(name, this.meterProviderSharedState, this.meterSharedState);
    }

    public DoubleValueObserverSdk.Builder doubleValueObserverBuilder(String name) {
        return new DoubleValueObserverSdk.Builder(name, this.meterProviderSharedState, this.meterSharedState);
    }

    public LongValueObserverSdk.Builder longValueObserverBuilder(String name) {
        return new LongValueObserverSdk.Builder(name, this.meterProviderSharedState, this.meterSharedState);
    }

    public BatchRecorderSdk newBatchRecorder(String ... keyValuePairs) {
        return new BatchRecorderSdk(keyValuePairs);
    }

    Collection<MetricData> collectAll(long epochNanos) {
        InstrumentRegistry instrumentRegistry = this.meterSharedState.getInstrumentRegistry();
        Collection<AbstractInstrument> instruments = instrumentRegistry.getInstruments();
        ArrayList<MetricData> result = new ArrayList<MetricData>(instruments.size());
        for (AbstractInstrument instrument : instruments) {
            result.addAll(instrument.collectAll(epochNanos));
        }
        return result;
    }
}

