/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.view;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.internal.RandomSupplier;
import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.PointData;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.internal.aggregator.DoubleBase2ExponentialHistogramAggregator;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;

public final class Base2ExponentialHistogramAggregation
implements Aggregation,
AggregatorFactory {
    private static final int DEFAULT_MAX_BUCKETS = 160;
    private static final int DEFAULT_MAX_SCALE = 20;
    private static final Aggregation DEFAULT = new Base2ExponentialHistogramAggregation(160, 20);
    private final int maxBuckets;
    private final int maxScale;

    private Base2ExponentialHistogramAggregation(int maxBuckets, int maxScale) {
        this.maxBuckets = maxBuckets;
        this.maxScale = maxScale;
    }

    public static Aggregation getDefault() {
        return DEFAULT;
    }

    public static Aggregation create(int maxBuckets, int maxScale) {
        Utils.checkArgument((maxBuckets >= 2 ? 1 : 0) != 0, (String)"maxBuckets must be >= 2");
        Utils.checkArgument((maxScale <= 20 && maxScale >= -10 ? 1 : 0) != 0, (String)"maxScale must be -10 <= x <= 20");
        return new Base2ExponentialHistogramAggregation(maxBuckets, maxScale);
    }

    @Override
    public <T extends PointData, U extends ExemplarData> Aggregator<T, U> createAggregator(InstrumentDescriptor instrumentDescriptor, ExemplarFilter exemplarFilter) {
        return new DoubleBase2ExponentialHistogramAggregator(() -> ExemplarReservoir.filtered(exemplarFilter, ExemplarReservoir.longToDouble(ExemplarReservoir.doubleFixedSizeReservoir(Clock.getDefault(), Runtime.getRuntime().availableProcessors(), RandomSupplier.platformDefault()))), this.maxBuckets, this.maxScale);
    }

    @Override
    public boolean isCompatibleWithInstrument(InstrumentDescriptor instrumentDescriptor) {
        switch (instrumentDescriptor.getType()) {
            case COUNTER: 
            case HISTOGRAM: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "Base2ExponentialHistogramAggregation{maxBuckets=" + this.maxBuckets + ",maxScale=" + this.maxScale + "}";
    }
}

