/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.aggregator;

import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.aggregator.DoubleSumAggregator;
import io.opentelemetry.sdk.metrics.aggregator.LongSumAggregator;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.resources.Resource;

final class SumAggregatorFactory
implements AggregatorFactory {
    private final AggregationTemporality temporality;

    SumAggregatorFactory(AggregationTemporality temporality) {
        this.temporality = temporality;
    }

    @Override
    public <T> Aggregator<T> create(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor descriptor) {
        switch (descriptor.getValueType()) {
            case LONG: {
                return new LongSumAggregator(resource, instrumentationLibraryInfo, descriptor, this.temporality);
            }
            case DOUBLE: {
                return new DoubleSumAggregator(resource, instrumentationLibraryInfo, descriptor, this.temporality);
            }
        }
        throw new IllegalArgumentException("Invalid instrument value type");
    }
}

