/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import java.util.Arrays;
import javax.annotation.Nullable;

final class AdaptingIntegerArray {
    @Nullable
    private byte[] byteBacking;
    @Nullable
    private short[] shortBacking;
    @Nullable
    private int[] intBacking;
    @Nullable
    private long[] longBacking;
    private ArrayCellSize cellSize;

    AdaptingIntegerArray(int size) {
        this.cellSize = ArrayCellSize.BYTE;
        this.byteBacking = new byte[size];
    }

    private AdaptingIntegerArray(AdaptingIntegerArray toCopy) {
        this.cellSize = toCopy.cellSize;
        switch (this.cellSize.ordinal()) {
            case 0: {
                this.byteBacking = Arrays.copyOf(toCopy.byteBacking, toCopy.byteBacking.length);
                break;
            }
            case 1: {
                this.shortBacking = Arrays.copyOf(toCopy.shortBacking, toCopy.shortBacking.length);
                break;
            }
            case 2: {
                this.intBacking = Arrays.copyOf(toCopy.intBacking, toCopy.intBacking.length);
                break;
            }
            case 3: {
                this.longBacking = Arrays.copyOf(toCopy.longBacking, toCopy.longBacking.length);
            }
        }
    }

    AdaptingIntegerArray copy() {
        return new AdaptingIntegerArray(this);
    }

    void increment(int idx, long count) {
        switch (this.cellSize.ordinal()) {
            case 0: {
                long result = (long)this.byteBacking[idx] + count;
                if (result > 127L) {
                    this.resizeToShort();
                    this.increment(idx, count);
                    return;
                }
                this.byteBacking[idx] = (byte)result;
                return;
            }
            case 1: {
                long result = (long)this.shortBacking[idx] + count;
                if (result > 32767L) {
                    this.resizeToInt();
                    this.increment(idx, count);
                    return;
                }
                this.shortBacking[idx] = (short)result;
                return;
            }
            case 2: {
                long result = (long)this.intBacking[idx] + count;
                if (result > Integer.MAX_VALUE) {
                    this.resizeToLong();
                    this.increment(idx, count);
                    return;
                }
                this.intBacking[idx] = (int)result;
                return;
            }
            case 3: {
                this.longBacking[idx] = this.longBacking[idx] + count;
                return;
            }
        }
    }

    long get(int index) {
        long value = 0L;
        switch (this.cellSize.ordinal()) {
            case 0: {
                value = this.byteBacking[index];
                break;
            }
            case 1: {
                value = this.shortBacking[index];
                break;
            }
            case 2: {
                value = this.intBacking[index];
                break;
            }
            case 3: {
                value = this.longBacking[index];
            }
        }
        return value;
    }

    int length() {
        int length = 0;
        switch (this.cellSize.ordinal()) {
            case 0: {
                length = this.byteBacking.length;
                break;
            }
            case 1: {
                length = this.shortBacking.length;
                break;
            }
            case 2: {
                length = this.intBacking.length;
                break;
            }
            case 3: {
                length = this.longBacking.length;
            }
        }
        return length;
    }

    void clear() {
        switch (this.cellSize.ordinal()) {
            case 0: {
                Arrays.fill(this.byteBacking, (byte)0);
                break;
            }
            case 1: {
                Arrays.fill(this.shortBacking, (short)0);
                break;
            }
            case 2: {
                Arrays.fill(this.intBacking, 0);
                break;
            }
            case 3: {
                Arrays.fill(this.longBacking, 0L);
            }
        }
    }

    private void resizeToShort() {
        short[] shortBacking = new short[this.byteBacking.length];
        for (int i = 0; i < this.byteBacking.length; ++i) {
            shortBacking[i] = this.byteBacking[i];
        }
        this.cellSize = ArrayCellSize.SHORT;
        this.shortBacking = shortBacking;
        this.byteBacking = null;
    }

    private void resizeToInt() {
        int[] intBacking = new int[this.shortBacking.length];
        for (int i = 0; i < this.shortBacking.length; ++i) {
            intBacking[i] = this.shortBacking[i];
        }
        this.cellSize = ArrayCellSize.INT;
        this.intBacking = intBacking;
        this.shortBacking = null;
    }

    private void resizeToLong() {
        long[] longBacking = new long[this.intBacking.length];
        for (int i = 0; i < this.intBacking.length; ++i) {
            longBacking[i] = this.intBacking[i];
        }
        this.cellSize = ArrayCellSize.LONG;
        this.longBacking = longBacking;
        this.intBacking = null;
    }

    private static enum ArrayCellSize {
        BYTE,
        SHORT,
        INT,
        LONG;

    }
}

