/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.BoundDoubleHistogram;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import io.opentelemetry.api.metrics.LongHistogramBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.AbstractInstrumentBuilder;
import io.opentelemetry.sdk.metrics.SdkLongHistogram;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;
import io.opentelemetry.sdk.metrics.internal.state.BoundStorageHandle;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;

final class SdkDoubleHistogram
extends AbstractInstrument
implements DoubleHistogram {
    private final WriteableMetricStorage storage;

    private SdkDoubleHistogram(InstrumentDescriptor descriptor, WriteableMetricStorage storage) {
        super(descriptor);
        this.storage = storage;
    }

    public void record(double value, Attributes attributes, Context context) {
        this.storage.recordDouble(value, attributes, context);
    }

    public void record(double value, Attributes attributes) {
        this.record(value, attributes, Context.current());
    }

    public void record(double value) {
        this.record(value, Attributes.empty());
    }

    public BoundDoubleHistogram bind(Attributes attributes) {
        return new BoundInstrument(this.storage.bind(attributes), attributes);
    }

    static final class Builder
    extends AbstractInstrumentBuilder<Builder>
    implements DoubleHistogramBuilder {
        Builder(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, String name) {
            this(meterProviderSharedState, meterSharedState, name, "", "1");
        }

        Builder(MeterProviderSharedState meterProviderSharedState, MeterSharedState sharedState, String name, String description, String unit) {
            super(meterProviderSharedState, sharedState, name, description, unit);
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public SdkDoubleHistogram build() {
            return this.buildSynchronousInstrument(InstrumentType.HISTOGRAM, InstrumentValueType.DOUBLE, (x$0, x$1) -> new SdkDoubleHistogram((InstrumentDescriptor)x$0, (WriteableMetricStorage)x$1));
        }

        public LongHistogramBuilder ofLongs() {
            return this.swapBuilder(SdkLongHistogram.Builder::new);
        }
    }

    static final class BoundInstrument
    implements BoundDoubleHistogram {
        private final BoundStorageHandle aggregatorHandle;
        private final Attributes attributes;

        BoundInstrument(BoundStorageHandle handle, Attributes attributes) {
            this.aggregatorHandle = handle;
            this.attributes = attributes;
        }

        public void record(double value, Context context) {
            this.aggregatorHandle.recordDouble(value, this.attributes, context);
        }

        public void record(double value) {
            this.record(value, Context.current());
        }

        public void unbind() {
            this.aggregatorHandle.release();
        }
    }
}

