/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.DoubleSumData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.aggregator.AbstractSumAggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.aggregator.MetricDataUtils;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Map;
import java.util.concurrent.atomic.DoubleAdder;

final class DoubleSumAggregator
extends AbstractSumAggregator<Double> {
    DoubleSumAggregator(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor instrumentDescriptor, MetricDescriptor metricDescriptor, AggregationTemporality temporality) {
        super(resource, instrumentationLibraryInfo, instrumentDescriptor, metricDescriptor, temporality);
    }

    @Override
    public AggregatorHandle<Double> createHandle() {
        return new Handle();
    }

    @Override
    public Double accumulateDouble(double value) {
        return value;
    }

    @Override
    Double mergeSum(Double previousAccumulation, Double accumulation) {
        return previousAccumulation + accumulation;
    }

    @Override
    Double mergeDiff(Double previousAccumulation, Double accumulation) {
        return accumulation - previousAccumulation;
    }

    @Override
    public MetricData toMetricData(Map<Attributes, Double> accumulationByLabels, long startEpochNanos, long lastCollectionEpoch, long epochNanos) {
        return MetricData.createDoubleSum(this.getResource(), this.getInstrumentationLibraryInfo(), this.getMetricDescriptor().getName(), this.getMetricDescriptor().getDescription(), this.getMetricDescriptor().getUnit(), DoubleSumData.create(this.isMonotonic(), this.temporality(), MetricDataUtils.toDoublePointList(accumulationByLabels, this.temporality() == AggregationTemporality.CUMULATIVE ? startEpochNanos : lastCollectionEpoch, epochNanos)));
    }

    static final class Handle
    extends AggregatorHandle<Double> {
        private final DoubleAdder current = new DoubleAdder();

        Handle() {
        }

        @Override
        protected Double doAccumulateThenReset() {
            return this.current.sumThenReset();
        }

        @Override
        protected void doRecordDouble(double value) {
            this.current.add(value);
        }
    }
}

